package shz.linked;

/**
 * 元素类型为long的单向链表节点
 * <p>
 * 16*n(n为元素个数)
 * <p>
 * B=16*(n+1)
 */
public class JSNode implements SNode {
    public long val;
    protected JSNode next;

    protected JSNode(long val) {
        this.val = val;
    }

    public static JSNode of(long e) {
        return new JSNode(e);
    }

    public static JSNode of() {
        return of(0L);
    }

    @Override
    public final JSNode next() {
        return next;
    }

    @Override
    public final void next(SNode node) {
        next = (JSNode) node;
    }

    @Override
    public final JSNode addPrev(SNode node) {
        addNext(node);
        long val = this.val;
        JSNode jsNode = (JSNode) node;
        this.val = jsNode.val;
        jsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (next != null) {
            this.val = next.val;
            next = next.next;
        } else this.val = 0L;
    }

    public final JSNode addNext(long e) {
        return (JSNode) addNext(of(e));
    }

    public final JSNode addNext(long... es) {
        JSNode next = this;
        for (long e : es) next = next.addNext(e);
        return next;
    }

    public final JSNode addPrev(long e) {
        return addPrev(of(e));
    }

    public final JSNode addPrev(long... es) {
        for (long e : es) addPrev(e);
        return this;
    }
}