package shz.linked;

/**
 * 元素类型为E的双向链表节点
 * <p>
 * [24+E(类型字节)+对齐填充]*n(n为元素个数)
 * <p>
 * B=16+24*n+(E+对齐填充)*n
 */
@SuppressWarnings("unchecked")
public class LDNode<E> implements DNode {
    public E val;
    protected LDNode<E> next;
    protected LDNode<E> prev;

    protected LDNode(E val) {
        this.val = val;
    }

    public static <E> LDNode<E> of(E e) {
        return new LDNode<>(e);
    }

    public static <E> LDNode<E> of() {
        return of(null);
    }

    @Override
    public final LDNode<E> next() {
        return next;
    }

    @Override
    public final void next(DNode node) {
        next = (LDNode<E>) node;
    }

    @Override
    public final LDNode<E> prev() {
        return prev;
    }

    @Override
    public final void prev(DNode node) {
        prev = (LDNode<E>) node;
    }

    public final LDNode<E> addNext(E e) {
        return (LDNode<E>) addNext(of(e));
    }

    @SafeVarargs
    public final LDNode<E> addNext(E... es) {
        LDNode<E> next = this;
        for (E e : es) next = next.addNext(e);
        return next;
    }

    public final LDNode<E> addPrev(E e) {
        return (LDNode<E>) addPrev(of(e));
    }

    @SafeVarargs
    public final LDNode<E> addPrev(E... es) {
        LDNode<E> prev = this;
        for (E e : es) prev = prev.addPrev(e);
        return prev;
    }
}