package shz.linked;

/**
 * 元素类型为E的单向链表节点
 * <p>
 * [16+E(类型字节)+对齐填充]*n(n为元素个数)
 * <p>
 * B=16*(n+1)+(E+对齐填充)*n
 */
@SuppressWarnings("unchecked")
public class LSNode<E> implements SNode {
    public E val;
    protected LSNode<E> next;

    protected LSNode(E val) {
        this.val = val;
    }

    public static <E> LSNode<E> of(E e) {
        return new LSNode<>(e);
    }

    public static <E> LSNode<E> of() {
        return of(null);
    }

    @Override
    public final LSNode<E> next() {
        return next;
    }

    @Override
    public final void next(SNode node) {
        next = (LSNode<E>) node;
    }

    @Override
    public final LSNode<E> addPrev(SNode node) {
        addNext(node);
        E val = this.val;
        LSNode<E> lsNode = (LSNode<E>) node;
        this.val = lsNode.val;
        lsNode.val = val;
        return this;
    }

    @Override
    public final void poll() {
        if (next != null) {
            this.val = next.val;
            next = next.next;
        } else this.val = null;
    }

    public final LSNode<E> addNext(E e) {
        return (LSNode<E>) addNext(of(e));
    }

    @SafeVarargs
    public final LSNode<E> addNext(E... es) {
        LSNode<E> next = this;
        for (E e : es) next = next.addNext(e);
        return next;
    }

    public final LSNode<E> addPrev(E e) {
        return addPrev(of(e));
    }

    @SafeVarargs
    public final LSNode<E> addPrev(E... es) {
        for (E e : es) addPrev(e);
        return this;
    }
}