package shz.linked;

import java.util.function.Function;
import java.util.function.Predicate;

/**
 * 单向链表节点
 */
public interface SNode {
    SNode next();

    void next(SNode node);

    default SNode addNext(SNode node) {
        node.next(next());
        next(node);
        return node;
    }

    SNode addPrev(SNode node);

    void poll();

    default SNode find(Predicate<SNode> predicate) {
        if (predicate == null) throw new NullPointerException();
        for (SNode next = this; next != null; next = next.next()) if (predicate.test(next)) return next;
        return null;
    }

    default void forEach(Function<SNode, Boolean> func) {
        if (func == null) throw new NullPointerException();
        for (SNode next = this; next != null; next = next.next()) {
            Boolean stop = func.apply(next);
            if (stop != null && stop) break;
        }
    }
}