package shz.model;

import shz.linked.LDNode;

public class Chain<T> {
    private final LDNode<Chain<T>> node;

    protected Chain() {
        node = LDNode.of(this);
    }

    public static <T> Chain<T> of() {
        return new Chain<>();
    }

    public final Chain<T> append(Chain<T> next) {
        node.addNext(next.node);
        return next;
    }

    public final Chain<T> head() {
        if (node.prev() == null) return this;
        return node.prev().val.head();
    }

    public final Chain<T> tail() {
        if (node.next() == null) return this;
        return node.next().val.tail();
    }

    public T execute(T t) {
        return t;
    }

    public final T doFilter(T t) {
        Chain<T> head = head();
        T execute = head.execute(t);
        while (head.node.next() != null && (head = head.node.next().val) != null) execute = head.execute(execute);
        return execute;
    }

    public final void doDuty(T t) {
        Chain<T> head = head();
        T execute = head.execute(t);
        if (execute == null) return;
        while (head.node.next() != null && (head = head.node.next().val) != null) {
            execute = head.execute(execute);
            if (execute == null) return;
        }
    }
}