package shz.model;

import shz.AccessibleHelp;
import shz.ToList;
import shz.enums.IEnum;
import shz.enums.TypeEnum;

import java.util.Collections;
import java.util.List;

public class CodeValue {
    /**
     * 编码
     */
    private String code;
    /**
     * 值
     */
    private String value;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "CodeValue{" +
                "code='" + code + '\'' +
                ", value='" + value + '\'' +
                '}';
    }

    public static List<CodeValue> of(String typeName) {
        List<IEnum<?, ?>> enums = AccessibleHelp.enumSet(typeName);
        if (enums.isEmpty()) return Collections.emptyList();
        return ToList.explicitCollect(enums.stream().map(e -> {
            CodeValue codeValue = new CodeValue();
            codeValue.setCode(String.valueOf(e.getCode()));
            codeValue.setValue(String.valueOf(e.getValue()));
            return codeValue;
        }), enums.size());
    }

    public static List<CodeValue> of(String typeName, String enumName) {
        List<IEnum<?, ?>> enums = AccessibleHelp.enumSet(typeName);
        if (enums.isEmpty()) return Collections.emptyList();
        IEnum<?, ?> iEnum = enums.stream().filter(e -> e.name().equals(enumName)).findFirst().orElse(null);
        return iEnum instanceof TypeEnum ? ((TypeEnum) iEnum).codeValues() : Collections.emptyList();
    }
}
