package shz.model;

import java.io.Serializable;

public final class IdPayload<ID, T> implements Serializable {
    private static final long serialVersionUID = -8759026411178181848L;
    private final ID id;
    private final T payload;

    private IdPayload(ID id, T payload) {
        this.id = id;
        this.payload = payload;
    }

    public static <ID, T> IdPayload<ID, T> of(ID id, T payload) {
        return new IdPayload<>(id, payload);
    }

    public static <ID, T> IdPayload<ID, T> of(ID id) {
        return of(id, null);
    }

    public ID id() {
        return id;
    }

    public T payload() {
        return payload;
    }

    @Override
    public String toString() {
        return "IdPayload{" +
                "id=" + id +
                ", payload=" + payload +
                '}';
    }
}