package shz.model;

import shz.Validator;

import java.util.HashMap;
import java.util.Map;

/**
 * 稀疏矩阵
 */
public final class SparseVector {
    private final Map<Integer, Double> st;

    private SparseVector(int capacity) {
        st = new HashMap<>(capacity);
    }

    public static SparseVector of(int capacity) {
        Validator.requireNon(capacity < 0);
        return new SparseVector(capacity);
    }

    public static SparseVector of() {
        return of(16);
    }

    public final int size() {
        return st.size();
    }

    public final void put(int key, double val) {
        st.put(key, val);
    }

    public final double get(int key) {
        if (!st.containsKey(key)) return 0d;
        return st.get(key);
    }

    public final double dot(double[] that) {
        double sum = 0d;
        for (int i : st.keySet()) sum += that[i] * get(i);
        return sum;
    }
}
