package shz.model;

import shz.Help;

import java.awt.geom.Rectangle2D;

/**
 * 球
 */
public class Sphere {
    /**
     * 地球半径
     */
    public static final double EARTH_RADIUS = 6378245.0D;

    private final double radius;

    public Sphere(double radius) {
        this.radius = radius;
    }

    private static final class SphereHolder {
        private static final Sphere EARTH = new Sphere(EARTH_RADIUS);
    }

    public static Sphere earth() {
        return SphereHolder.EARTH;
    }

    /**
     * 计算多边形面积
     * <p>
     * 对于球面N边形，所有角的和为S,球的半径为R，面积计算公式：(S−(N−2)∗Pi)∗R∗R
     */
    public final double area(double[] xs, double[] ys, int scale) {
        return Help.setScale((new Polygon(xs, ys).degreeSum() - (xs.length - 2) * Math.PI) * radius * radius, scale);
    }

    public static final double RADIAN = Math.PI / 180;

    /**
     * 计算球面距离
     *
     * @param x1 经度1
     * @param y1 纬度1
     * @param x2 经度2
     * @param y2 纬度2
     */
    public final double distance(double x1, double y1, double x2, double y2, int scale) {
        return Help.setScale(radius * Math.acos(Math.cos((x1 - x2) * RADIAN) * Math.cos((y1 - y2) * RADIAN)), scale);
    }

    /**
     * 中国经度左值
     */
    public static final double CHINA_LONGITUDE_LEFT = 72.004D;
    /**
     * 中国经度右值
     */
    public static final double CHINA_LONGITUDE_RIGHT = 137.8347D;
    /**
     * 中国纬度下值
     */
    public static final double CHINA_LATITUDE_DOWN = 0.8293D;
    /**
     * 中国纬度上值
     */
    public static final double CHINA_LATITUDE_UP = 55.8271D;

    public static boolean outOfChina(double lon, double lat) {
        return lon < CHINA_LONGITUDE_LEFT
                || lon > CHINA_LONGITUDE_RIGHT
                || lat < CHINA_LATITUDE_DOWN
                || lat > CHINA_LATITUDE_UP;
    }

    /**
     * 获取经纬度范围
     *
     * @param x        目标点经度
     * @param y        目标点纬度
     * @param distance 距目标点距离(单位 m)
     */
    public Rectangle2D.Double rectangle(double x, double y, double distance, double lonDifferential, double latDifferential) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        double lon = 180.0D, lonMax = lon, lonMin = 0.0D;
        double latRadius = radius * Math.cos(y * RADIAN);
        while (true) {
            while (latRadius * Math.acos(Math.cos(lon * RADIAN)) > distance) {
                lonMax = lon;
                lon = (lonMin + lon) / 2;
            }
            if (lonMax - lon <= lonDifferential) {
                if (x - lon <= -180.0D) {
                    rectangle.x = x + lon;
                    rectangle.width = lon - x - 180.0D - rectangle.x;
                } else {
                    rectangle.x = x - lon;
                    rectangle.width = x + lon - rectangle.x;
                }
                break;
            }
            lonMin = lon;
            lon = (lonMax + lon) / 2;
        }

        double lat = 90.0D, latMax = lat, latMin = 0.0D;
        while (true) {
            while (radius * Math.acos(Math.cos(lat * RADIAN)) > distance) {
                latMax = lat;
                lat = (latMin + lat) / 2;
            }
            if (latMax - lat <= latDifferential) {
                rectangle.y = Math.max(y - lat, -90.0D);
                rectangle.height = y + lat - rectangle.y;
                break;
            }
            latMin = lat;
            lat = (latMax + lat) / 2;
        }
        return rectangle;
    }

    public Rectangle2D.Double rectangle(double x, double y, double distance) {
        return rectangle(x, y, distance, 0.00001D, 0.000005D);
    }
}
