package shz.model;

import shz.PRException;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class SyncRequest<T> {
    private volatile T response;
    private final CountDownLatch latch;
    private final AtomicInteger state;

    private SyncRequest() {
        latch = new CountDownLatch(1);
        state = new AtomicInteger();
    }

    public static <T> SyncRequest<T> of() {
        return new SyncRequest<>();
    }

    public T waitFor(long timeout, TimeUnit unit) throws TimeoutException {
        state.compareAndSet(0, 1);
        try {
            if (timeout <= 0L) latch.await();
            else latch.await(timeout, unit);
        } catch (InterruptedException e) {
            if (state.get() == 1) throw PRException.of(e);
        }
        if (state.compareAndSet(1, 2)) throw new TimeoutException();
        while (latch.getCount() != 0L) try {
            latch.await(500L, TimeUnit.MICROSECONDS);
        } catch (InterruptedException ignored) {
        }
        return response;
    }

    public boolean reach(T response) {
        if (!state.compareAndSet(0, 2) && !state.compareAndSet(1, 2)) return false;
        this.response = response;
        latch.countDown();
        return true;
    }
}