package shz.msg;

public enum ClientFailure implements ClientFailureMsg {
    BAD_REQUEST(400, "错误请求"),
    UNAUTHORIZED(401, "身份未认证"),
    PAYMENT_REQUIRED(402, "保留"),
    FORBIDDEN(403, "拒绝访问"),
    NOT_FOUND(404, "资源不存在"),
    BAD_METHOD(405, "请求方法被禁用"),
    NOT_ACCEPTABLE(406, "不支持的内容特性"),
    PROXY_AUTH(407, "代理身份未认证"),
    CLIENT_TIMEOUT(408, "发送超时"),
    CONFLICT(409, "请求冲突"),
    GONE(410, "资源被永久删除"),
    LENGTH_REQUIRED(411, "缺少Content-Length"),
    PRECON_FAILED(412, "请求信息先决条件错误"),
    ENTITY_TOO_LARGE(413, "请求实体过大"),
    REQ_TOO_LONG(414, "请求URI过长"),
    UNSUPPORTED_TYPE(415, "不支持的媒体格式"),
    RANG_NOT_SATISFIABLE(416, "数据范围不满足"),
    EXPECTATION_FAILED(417, "预期内容无法被满足"),
    TOO_MANY_CONNECTIONS(421, "连接数过多"),
    UNPROCESSABLE_ENTITY(422, "语义错误"),
    LOCKED(423, "当前资源被锁定"),
    FAILED_DEPENDENCY(424, "请求失败"),
    UPGRADE_REQUIRED(426, "客户端应当切换到TLS/1.0"),
    TOO_MANY_REQUESTS(429, "请求频繁,请稍后再试"),
    RETRY_WITH(449, "进行重试"),

    MISSING_ID("缺少id"),
    MISSING_BODY("缺少数据"),
    INVALID_BODY("数据格式错误"),
    RPC_MISSING_CLASS_NAME_OR_METHOD_NAME("RPC调用缺少类名或方法名"),

    MISSING_TOKEN("缺少token"),
    INVALID_TOKEN("无效token"),

    MISSING_SIGNATURE("缺少签名"),
    INVALID_SIGNATURE("无效签名"),

    INVALID_VERIFY_CODE("验证码已失效,请重新获取"),
    ERROR_VERIFY_CODE("验证码错误"),

    ;

    private final int code;
    private final String msg;

    ClientFailure(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    ClientFailure(String msg) {
        this(400, msg);
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String msg() {
        return msg;
    }
}
