package shz.msg;

import shz.Help;
import shz.PRException;
import shz.Validator;

public interface ClientFailureMsg extends FailureMsg {
    @Override
    default int code() {
        return 400;
    }

    static ClientFailureMsg fail(String msg) {
        return () -> msg;
    }

    static ClientFailureMsg fail(String format, Object... args) {
        return fail(Help.format(format, args));
    }

    static void requireNon(boolean condition, String msg) {
        if (condition) throw PRException.of(fail(msg));
    }

    static void requireNon(boolean condition, String format, Object... args) {
        if (condition) throw PRException.of(fail(format, args));
    }

    static void requireNonNull(Object obj, String msg) {
        if (obj == null) throw PRException.of(fail(msg));
    }

    static void requireNonNull(Object obj, String format, Object... args) {
        if (obj == null) throw PRException.of(fail(format, args));
    }

    static void requireNonEmpty(Object obj, String msg) {
        if (Validator.isEmpty(obj)) throw PRException.of(fail(msg));
    }

    static void requireNonEmpty(Object obj, String format, Object... args) {
        if (Validator.isEmpty(obj)) throw PRException.of(fail(format, args));
    }

    static void requireNonBlank(Object obj, String msg) {
        if (Validator.isBlank(obj)) throw PRException.of(fail(msg));
    }

    static void requireNonBlank(Object obj, String format, Object... args) {
        if (Validator.isBlank(obj)) throw PRException.of(fail(format, args));
    }
}
