package shz.msg;

import shz.Response;

public interface Message {
    int code();

    String msg();

    boolean isOk();

    static Message of(Response<?> response) {
        if (response == null) return ServerFailure.INTERNAL_ERROR;
        return response.isOk() ? SuccessMsg.ok(response.getMsg()) : FailureMsg.fail(response.getCode(), response.getMsg());
    }
}