package shz.msg;

public enum ServerFailure implements ServerFailureMsg {
    INTERNAL_ERROR(500, "服务器错误"),
    NOT_IMPLEMENTED(501, "服务器不支持请求的功能"),
    BAD_GATEWAY(502, "服务器异常"),
    UNAVAILABLE(503, "服务器维护中"),
    GATEWAY_TIMEOUT(504, "服务器繁忙"),
    VERSION(505, "服务器不支持的HTTP协议版本"),

    VARIANT_ALSO_NEGOTIATES(506, "服务器内部配置错误"),
    INSUFFICIENT_STORAGE(507, "服务器无法存储完成请求所必须的内容"),
    BANDWIDTH_LIMIT_EXCEEDED(509, "服务器达到带宽限制"),
    NOT_EXTENDED(510, "服务器不支持请求的策略"),

    IllegalThreadStateException("线程非法调用"),
    NumberFormatException("字符串无法转换为数值类型"),
    IllegalArgumentException("不合法或不正确的参数"),

    SecurityException("非法侵犯"),
    UnsupportedOperationException("不支持的操作请求"),
    IllegalAccessException("拒绝访问"),

    IllegalStateException("非法调用"),
    ClassNotFoundException("找不到此类"),
    CloneNotSupportedException("此类不支持克隆"),
    InstantiationException("接口或抽象类无法实例化"),
    InterruptedException("线程被中断"),
    NoSuchFieldException("请求的变量不存在"),
    NoSuchMethodException("请求的方法不存在"),
    ArithmeticException("异常的运算条件"),
    ArrayIndexOutOfBoundsException("数组索引超出范围"),
    ArrayStoreException("错误类型"),
    ClassCastException("不是实例的子类"),
    IllegalMonitorStateException("线程没有指定监视器"),

    StringIndexOutOfBoundsException("字符串索引为负，或者超出大小"),
    IndexOutOfBoundsException("索引超出范围"),

    NegativeArraySizeException("数组大小不能为负数"),

    RPC_MISSING_INSTANCE("RPC调用缺少实例"),

    ;

    private final int code;
    private final String msg;

    ServerFailure(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    ServerFailure(String msg) {
        this(500, msg);
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String msg() {
        return msg;
    }
}
