package shz.msg;

public enum Success implements SuccessMsg {
    OK(200, "请求成功"),
    CREATED(201, "已创建"),
    ACCEPTED(202, "已接受"),
    NOT_AUTHORITATIVE(203, "非授权信息"),
    NO_CONTENT(204, "无内容"),
    RESET(205, "重置内容"),
    PARTIAL(206, "部分内容"),
    MULTI_STATUS(207, "XML消息"),

    ;

    private final int code;
    private final String msg;

    Success(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String msg() {
        return msg;
    }
}
