package shz.queue;

/**
 * 元素类型为byte基于循环动态数组的队列
 * <p>
 * 24+n(n为元素个数)=es
 * <p>
 * B=56+n+对齐填充
 */
public class BArrayQueue extends ArrayQueue<Byte> {
    protected byte[] es;

    protected BArrayQueue(int capacity) {
        super(capacity);
        es = new byte[capacity];
    }

    public static BArrayQueue of(int capacity) {
        return new BArrayQueue(capacity);
    }

    public static BArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Byte get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        byte[] temp = new byte[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void offer(byte e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final byte poll() {
        byte e = es[head];
        afterPoll();
        return e;
    }

    public final byte head() {
        return es[head];
    }

    public final byte tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
