package shz.queue;

/**
 * 元素类型为char基于循环动态数组的队列
 * <p>
 * 24+2*n(n为元素个数)=es
 * <p>
 * B=56+2*n+对齐填充
 */
public class CArrayQueue extends ArrayQueue<Character> {
    protected char[] es;

    protected CArrayQueue(int capacity) {
        super(capacity);
        es = new char[capacity];
    }

    public static CArrayQueue of(int capacity) {
        return new CArrayQueue(capacity);
    }

    public static CArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Character get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        char[] temp = new char[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void offer(char e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final char poll() {
        char e = es[head];
        afterPoll();
        return e;
    }

    public final char head() {
        return es[head];
    }

    public final char tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
