package shz.queue;

/**
 * 元素类型为double基于循环动态数组的队列
 * <p>
 * 24+8*n(n为元素个数)=es
 * <p>
 * B=56+8*n
 */
public class DArrayQueue extends ArrayQueue<Double> {
    protected double[] es;

    protected DArrayQueue(int capacity) {
        super(capacity);
        es = new double[capacity];
    }

    public static DArrayQueue of(int capacity) {
        return new DArrayQueue(capacity);
    }

    public static DArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Double get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        double[] temp = new double[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0d;
    }

    public final void offer(double e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final double poll() {
        double e = es[head];
        afterPoll();
        return e;
    }

    public final double head() {
        return es[head];
    }

    public final double tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
