package shz.queue;

import shz.linked.DSNode;
import shz.linked.SNode;

/**
 * 元素类型为double基于链表的队列
 * <p>
 * 20+16*(n+1)(n为元素个数)
 * <p>
 * B=8+16*(n+3)
 */
public class DLinkedQueue extends LinkedQueue<Double> {
    protected DLinkedQueue() {
    }

    public static DLinkedQueue of() {
        return new DLinkedQueue();
    }

    @Override
    protected final Double get(SNode node) {
        return ((DSNode) node).val;
    }


    public final void offer(double e) {
        SNode temp = tail;
        tail = DSNode.of(e);
        if (head == null) head = tail;
        else temp.next(tail);
        ++size;
    }

    public final double poll() {
        double val = head();
        head = head.next();
        if (head == null) tail = null;
        --size;
        return val;
    }

    public final double head() {
        return ((DSNode) head).val;
    }

    public final double tail() {
        return ((DSNode) tail).val;
    }
}
