package shz.queue;

/**
 * 元素类型为float基于循环动态数组的队列
 * <p>
 * 24+4*n(n为元素个数)=es
 * <p>
 * B=56+4*n+对齐填充
 */
public class FArrayQueue extends ArrayQueue<Float> {
    protected float[] es;

    protected FArrayQueue(int capacity) {
        super(capacity);
        es = new float[capacity];
    }

    public static FArrayQueue of(int capacity) {
        return new FArrayQueue(capacity);
    }

    public static FArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Float get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        float[] temp = new float[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0f;
    }

    public final void offer(float e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final float poll() {
        float e = es[head];
        afterPoll();
        return e;
    }

    public final float head() {
        return es[head];
    }

    public final float tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
