package shz.queue;

/**
 * 元素类型为int基于循环动态数组的队列
 * <p>
 * 24+4*n(n为元素个数)=es
 * <p>
 * B=56+4*n+对齐填充
 */
public class IArrayQueue extends ArrayQueue<Integer> {
    protected int[] es;

    protected IArrayQueue(int capacity) {
        super(capacity);
        es = new int[capacity];
    }

    public static IArrayQueue of(int capacity) {
        return new IArrayQueue(capacity);
    }

    public static IArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Integer get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        int[] temp = new int[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void offer(int e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final int poll() {
        int e = es[head];
        afterPoll();
        return e;
    }

    public final int head() {
        return es[head];
    }

    public final int tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
