package shz.queue;

/**
 * 元素类型为long基于循环动态数组的队列
 * <p>
 * 24+8*n(n为元素个数)=es
 * <p>
 * B=56+8*n
 */
public class JArrayQueue extends ArrayQueue<Long> {
    protected long[] es;

    protected JArrayQueue(int capacity) {
        super(capacity);
        es = new long[capacity];
    }

    public static JArrayQueue of(int capacity) {
        return new JArrayQueue(capacity);
    }

    public static JArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Long get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        long[] temp = new long[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0L;
    }

    public final void offer(long e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final long poll() {
        long e = es[head];
        afterPoll();
        return e;
    }

    public final long head() {
        return es[head];
    }

    public final long tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
