package shz.queue;

import shz.linked.JSNode;
import shz.linked.SNode;

/**
 * 元素类型为long基于链表的队列
 * <p>
 * 20+16*(n+1)(n为元素个数)
 * <p>
 * B=8+16*(n+3)
 */
public class JLinkedQueue extends LinkedQueue<Long> {
    protected JLinkedQueue() {
    }

    public static JLinkedQueue of() {
        return new JLinkedQueue();
    }

    @Override
    protected final Long get(SNode node) {
        return ((JSNode) node).val;
    }

    public final void offer(long e) {
        SNode temp = tail;
        tail = JSNode.of(e);
        if (head == null) head = tail;
        else temp.next(tail);
        ++size;
    }

    public final long poll() {
        long val = head();
        head = head.next();
        if (head == null) tail = null;
        --size;
        return val;
    }

    public final long head() {
        return ((JSNode) head).val;
    }

    public final long tail() {
        return ((JSNode) tail).val;
    }
}
