package shz.queue;

/**
 * 元素类型为E基于循环动态数组的队列
 * <p>
 * 24+[8+E(类型字节)]*n(n为元素个数)=es
 * <p>
 * B=56+8*n+(E*n+对齐填充)
 */
@SuppressWarnings("unchecked")
public class LArrayQueue<E> extends ArrayQueue<E> {
    protected E[] es;

    protected LArrayQueue(int capacity) {
        super(capacity);
        es = (E[]) new Object[capacity];
    }

    public static <E> LArrayQueue<E> of(int capacity) {
        return new LArrayQueue<>(capacity);
    }

    public static <E> LArrayQueue<E> of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final E get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        E[] temp = (E[]) new Object[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = null;
    }

    public final void offer(E e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final E poll() {
        E e = es[head];
        afterPoll();
        return e;
    }

    public final E head() {
        return es[head];
    }

    public final E tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
