package shz.queue;

import shz.linked.LSNode;
import shz.linked.SNode;

/**
 * 元素类型为E基于链表的队列
 * <p>
 * 20+16*(n+1)+(E+对齐填充)*n(n为元素个数)
 * <p>
 * B=8+16*(n+3)+(E+对齐填充)*n
 */
@SuppressWarnings("unchecked")
public class LLinkedQueue<E> extends LinkedQueue<E> {
    protected LLinkedQueue() {
    }

    public static <E> LLinkedQueue<E> of() {
        return new LLinkedQueue<>();
    }

    @Override
    protected final E get(SNode node) {
        return ((LSNode<E>) node).val;
    }

    public final void offer(E e) {
        SNode temp = tail;
        tail = LSNode.of(e);
        if (head == null) head = tail;
        else temp.next(tail);
        ++size;
    }

    public final E poll() {
        E val = head();
        head = head.next();
        if (head == null) tail = null;
        --size;
        return val;
    }

    public final E head() {
        return get(head);
    }

    public final E tail() {
        return get(tail);
    }
}
