package shz.queue;

import shz.linked.SNode;

import java.util.Iterator;

/**
 * 基于链表的队列
 */
public abstract class LinkedQueue<E> implements Iterable<E> {
    protected SNode tail, head;
    protected int size;

    protected LinkedQueue() {
    }

    public final class LinkedQueueIterator implements Iterator<E> {
        private SNode current = head;

        @Override
        public boolean hasNext() {
            return current != null;
        }

        @Override
        public E next() {
            E val = get(current);
            current = current.next();
            return val;
        }
    }

    protected abstract E get(SNode node);

    @Override
    public Iterator<E> iterator() {
        return new LinkedQueueIterator();
    }

    public int size() {
        return size;
    }

    public boolean isEmpty() {
        return head == null;
    }
}
