package shz.queue;

/**
 * 元素类型为short基于循环动态数组的队列
 * <p>
 * 24+2*n(n为元素个数)=es
 * <p>
 * B=56+2*n+对齐填充
 */
public class SArrayQueue extends ArrayQueue<Short> {
    protected short[] es;

    protected SArrayQueue(int capacity) {
        super(capacity);
        es = new short[capacity];
    }

    public static SArrayQueue of(int capacity) {
        return new SArrayQueue(capacity);
    }

    public static SArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Short get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        short[] temp = new short[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void offer(short e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final short poll() {
        short e = es[head];
        afterPoll();
        return e;
    }

    public final short head() {
        return es[head];
    }

    public final short tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
