package shz.queue;

/**
 * 元素类型为boolean基于循环动态数组的队列
 * <p>
 * 24+n(n为元素个数)=es
 * <p>
 * B=56+n+对齐填充
 */
public class ZArrayQueue extends ArrayQueue<Boolean> {
    protected boolean[] es;

    protected ZArrayQueue(int capacity) {
        super(capacity);
        es = new boolean[capacity];
    }

    public static ZArrayQueue of(int capacity) {
        return new ZArrayQueue(capacity);
    }

    public static ZArrayQueue of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Boolean get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        boolean[] temp = new boolean[capacity];
        for (int i = 0; i < size; ++i) temp[i] = es[(i + head) % capacity];
        head = 0;
        tail = size;
        es = temp;
    }

    @Override
    protected final void setNull(int i) {
        es[i] = false;
    }

    public final void offer(boolean e) {
        beforeOffer();
        es[tail] = e;
        afterOffer();
    }

    public final boolean poll() {
        boolean e = es[head];
        afterPoll();
        return e;
    }

    public final boolean head() {
        return es[head];
    }

    public final boolean tail() {
        return es[tail == 0 ? capacity - 1 : tail - 1];
    }
}
