package shz.st.bst.ixx;

/**
 * 健为int类型，值为V类型的红黑树
 * <p>
 * 8+[49+V(类型字节)+对齐填充]*n(n为元素个数)
 * <p>
 * B=24+48*n+(1+V+对齐填充)*n
 */
public class ILRedBlackBST<V> extends IXXRedBlackBST {
    /**
     * 8+V(类型字节)+25+对齐填充
     * <p>
     * B=49+V(类型字节)+对齐填充
     */
    protected static final class Node<V> extends IXXRedBlackBST.Node {
        public V val;

        public Node(int key, V val, boolean red) {
            super(key, red);
            this.val = val;
        }

        public Node(int key, V val) {
            this(key, val, true);
        }
    }

    protected ILRedBlackBST(int key, V val) {
        super(new Node<>(key, val, false));
    }

    public static <V> ILRedBlackBST<V> of(int key, V val) {
        return new ILRedBlackBST<>(key, val);
    }

    public static <V> ILRedBlackBST<V> of(int key) {
        return of(key, null);
    }

    public final void put(int key, V val) {
        root = put(root(), key, val);
        root.red = false;
    }

    protected final Node<V> put(Node<V> h, int key, V val) {
        if (h == null) return new Node<>(key, val);
        if (key < h.key) h.left = put(h.left(), key, val);
        else if (key > h.key) h.right = put(h.right(), key, val);
        else h.val = val;
        //如果右子结点是红色的而左子结点是黑色的，进行左旋转
        if (isRed(h.right) && !isRed(h.left)) h = rotateLeft(h);
        //如果左子结点是红色的且它的左子结点也是红色的，进行右旋转
        if (isRed(h.left) && isRed(h.left.left)) h = rotateRight(h);
        //如果左右子结点均为红色，进行颜色转换
        if (isRed(h.left) && isRed(h.right)) flipColors(h);
        h.size = size(h.left) + size(h.right) + 1;
        return h;
    }

    public final V get(int key) {
        Node<V> h = get(root(), key);
        return h == null ? null : h.val;
    }

    protected final Node<V> get(Node<V> h, int key) {
        while (h != null) {
            if (key == h.key) break;
            h = key < h.key ? h.left() : h.right();
        }
        return h;
    }

    public final void delete(int key) {
        if (root == null) return;
        if (!isRed(root.left) && !isRed(root.right)) root.red = true;
        root = delete(root(), key);
        if (root == null) return;
        if (!isEmpty()) root.red = false;
    }

    protected final Node<V> delete(Node<V> h, int key) {
        if (key < h.key) {
            if (!isRed(h.left) && !isRed(h.left.left)) h = moveRedLeft(h);
            h.left = delete(h.left(), key);
        } else {
            if (isRed(h.left)) h = rotateRight(h);
            if (key == h.key && h.right == null) return null;
            if (!isRed(h.right) && !isRed(h.right.left)) h = moveRedRight(h);
            if (key == h.key) {
                Node<V> min = min(h.right);
                h.val = get(h.right(), min.key).val;
                h.key = min.key;
                h.right = deleteMin(h.right);
            } else h.right = delete(h.right(), key);
        }
        return balance(h);
    }
}
