package shz.st.bst.ixx;

import shz.queue.IArrayQueue;
import shz.st.bst.RedBlackBST;

/**
 * 健为int类型的红黑树
 */
public abstract class IXXRedBlackBST extends RedBlackBST<Integer> {
    protected static abstract class Node extends RedBlackBST.Node {
        protected int key;

        protected Node(int key, boolean red) {
            super(red);
            this.key = key;
        }
    }

    protected IXXRedBlackBST(Node root) {
        super(root);
    }

    protected final Integer key(RedBlackBST.Node h) {
        return ((Node) h).key;
    }

    /**
     * 返回不大于hi的节点数量
     */
    public final int sizeLe(int hi) {
        return sizeLe(root(), hi);
    }

    protected final int sizeLe(Node h, int hi) {
        int res = 0;
        while (h != null) {
            if (hi < h.key) h = h.left();
            else {
                res += 1 + size(h.left);
                h = h.right();
            }
        }
        return res;
    }

    /**
     * 返回不小于lo的节点数量
     */
    public final int sizeGe(int lo) {
        return sizeGe(root(), lo);
    }

    protected final int sizeGe(Node x, int lo) {
        int res = 0;
        while (x != null) {
            if (lo > x.key) x = x.right();
            else {
                res += 1 + size(x.right);
                x = x.left();
            }
        }
        return res;
    }

    /**
     * 返回在区间[lo,hi]的节点数量
     */
    public final int size(int lo, int hi) {
        if (lo > hi) throw new IllegalArgumentException();
        return size(root(), lo, hi);
    }

    protected final int size(Node x, int lo, int hi) {
        int res = 0;
        while (x != null) {
            if (lo > x.key) x = x.right();
            else if (lo == x.key) {
                res += 1 + sizeLe(x.right(), hi);
                break;
            } else if (hi < x.key) x = x.left();
            else {
                res += sizeGe(x.left(), lo) + 1 + sizeLe(x.right(), hi);
                break;
            }
        }
        return res;
    }

    public final Integer floor(int key) {
        Node h = floor(root(), key);
        return h == null ? null : h.key;
    }

    protected final Node floor(Node h, int key) {
        Node res = null;
        while (h != null) {
            if (key == h.key) return h;
            if (key < h.key) h = h.left();
            else {
                res = h;
                h = h.right();
            }
        }
        return res;
    }

    public final Integer ceil(int key) {
        Node h = ceil(root(), key);
        return h == null ? null : h.key;
    }

    protected final Node ceil(Node h, int key) {
        Node res = null;
        while (h != null) {
            if (key == h.key) return h;
            if (key > h.key) h = h.right();
            else {
                res = h;
                h = h.left();
            }
        }
        return res;
    }

    /**
     * 查找所有键(中序遍历)
     */
    public final Iterable<Integer> keys() {
        IArrayQueue queue = IArrayQueue.of();
        keys(root(), queue);
        return queue;
    }

    protected final void keys(Node h, IArrayQueue queue) {
        if (h == null) return;
        keys(h.left(), queue);
        queue.offer(h.key);
        keys(h.right(), queue);
    }

    /**
     * 查找所有不大于hi的键
     */
    public final Iterable<Integer> keysLe(int hi) {
        IArrayQueue queue = IArrayQueue.of();
        keysLe(root(), queue, hi);
        return queue;
    }

    protected final void keysLe(Node h, IArrayQueue queue, int hi) {
        if (h == null) return;
        if (hi < h.key) keysLe(h.left(), queue, hi);
        else {
            keys(h.left(), queue);
            queue.offer(h.key);
            keysLe(h.right(), queue, hi);
        }
    }

    /**
     * 查找所有不小于lo的键
     */
    public final Iterable<Integer> keysGe(int lo) {
        IArrayQueue queue = IArrayQueue.of();
        keysGe(root(), queue, lo);
        return queue;
    }

    protected final void keysGe(Node h, IArrayQueue queue, int lo) {
        if (h == null) return;
        if (lo > h.key) keysGe(h.right(), queue, lo);
        else {
            keysGe(h.left(), queue, lo);
            queue.offer(h.key);
            keys(h.right(), queue);
        }
    }

    /**
     * 查找所有在区间[lo,hi]的键
     */
    public final Iterable<Integer> keys(int lo, int hi) {
        if (lo > hi) throw new IllegalArgumentException();
        IArrayQueue queue = IArrayQueue.of();
        keys(root(), queue, lo, hi);
        return queue;
    }

    protected final void keys(Node h, IArrayQueue queue, int lo, int hi) {
        if (h == null) return;
        if (lo > h.key) {
            keys(h.right(), queue, lo, hi);
        } else if (lo == h.key) {
            queue.offer(h.key);
            keysLe(h.right(), queue, hi);
        } else {
            if (hi >= h.key) {
                keysGe(h.left(), queue, lo);
                queue.offer(h.key);
                keysLe(h.right(), queue, hi);
            } else keys(h.left(), queue, lo, hi);
        }
    }
}
