package shz.st.bst.jxx;

/**
 * 健为long类型，值为char类型的红黑树
 * <p>
 * 8+48*n(n为元素个数)
 * <p>
 * B=24+48*n
 */
public class JCRedBlackBST extends JXXRedBlackBST {
    /**
     * 2+29+对齐填充=32
     * <p>
     * B=48
     */
    protected static final class Node extends JXXRedBlackBST.Node {
        public char val;

        public Node(long key, char val, boolean red) {
            super(key, red);
            this.val = val;
        }

        public Node(long key, char val) {
            this(key, val, true);
        }
    }

    protected JCRedBlackBST(long key, char val) {
        super(new JLRedBlackBST.Node<>(key, val, false));
    }


    public static JCRedBlackBST of(long key, char val) {
        return new JCRedBlackBST(key, val);
    }

    public static JCRedBlackBST of(long key) {
        return of(key, (char) 0);
    }

    public final void put(long key, char val) {
        root = put(root(), key, val);
        root.red = false;
    }

    protected final Node put(Node h, long key, char val) {
        if (h == null) return new Node(key, val);
        if (key < h.key) h.left = put(h.left(), key, val);
        else if (key > h.key) h.right = put(h.right(), key, val);
        else h.val = val;
        //如果右子结点是红色的而左子结点是黑色的，进行左旋转
        if (isRed(h.right) && !isRed(h.left)) h = rotateLeft(h);
        //如果左子结点是红色的且它的左子结点也是红色的，进行右旋转
        if (isRed(h.left) && isRed(h.left.left)) h = rotateRight(h);
        //如果左右子结点均为红色，进行颜色转换
        if (isRed(h.left) && isRed(h.right)) flipColors(h);
        h.size = size(h.left) + size(h.right) + 1;
        return h;
    }

    public final Character get(long key) {
        Node h = get(root(), key);
        return h == null ? null : h.val;
    }

    protected final Node get(Node h, long key) {
        while (h != null) {
            if (key == h.key) break;
            h = key < h.key ? h.left() : h.right();
        }
        return h;
    }

    public final void delete(long key) {
        if (root == null) return;
        if (!isRed(root.left) && !isRed(root.right)) root.red = true;
        root = delete(root(), key);
        if (root == null) return;
        if (!isEmpty()) root.red = false;
    }

    protected final Node delete(Node h, long key) {
        if (key < h.key) {
            if (!isRed(h.left) && !isRed(h.left.left)) h = moveRedLeft(h);
            h.left = delete(h.left(), key);
        } else {
            if (isRed(h.left)) h = rotateRight(h);
            if (key == h.key && h.right == null) return null;
            if (!isRed(h.right) && !isRed(h.right.left)) h = moveRedRight(h);
            if (key == h.key) {
                Node min = min(h.right);
                h.val = get(h.right(), min.key).val;
                h.key = min.key;
                h.right = deleteMin(h.right);
            } else h.right = delete(h.right(), key);
        }
        return balance(h);
    }
}
