package shz.st.hst;

public abstract class HST {
    protected static final int DEFAULT_CAPACITY = 16;
    protected int size, capacity;

    protected HST(int capacity) {
        if (capacity < 1) throw new IllegalArgumentException();
        this.capacity = capacity;
    }

    public final int size() {
        return size;
    }

    public final boolean isEmpty() {
        return size == 0;
    }

    protected final void beforePut() {
        if (size >= capacity >>> 1) {
            if (capacity == Integer.MAX_VALUE) throw new OutOfMemoryError();
            resize(capacity >= Integer.MAX_VALUE >> 1 ? Integer.MAX_VALUE : capacity << 1);
        }
    }

    protected abstract void resize(int capacity);
}
