package shz.st.tst;

import shz.queue.DLinkedQueue;
import shz.stack.LLinkedStack;

import java.util.Collections;
import java.util.function.Predicate;

/**
 * 值为double类型的TST
 * <p>
 * 8+56*n(n为元素个数)
 * <p>
 * B=24+56*n
 */
public class DTST extends TST {
    /**
     * 8+27+对齐填充=40
     * <p>
     * B=56
     */
    protected static final class Node extends TST.Node {
        public double val;

        public Node(char c) {
            super(c);
        }
    }

    protected DTST() {
    }

    public static DTST of() {
        return new DTST();
    }

    public final void put(char[] a, double val) {
        if (a == null) throw new NullPointerException();
        root = put(root(), a, val, 0);
    }

    protected final Node put(Node x, char[] a, double val, int d) {
        if (x == null) x = new Node(a[d]);
        if (a[d] < x.c) x.left = put(x.left(), a, val, d);
        else if (a[d] > x.c) x.right = put(x.right(), a, val, d);
        else if (d < a.length - 1) x.mid = put(x.mid(), a, val, d + 1);
        else {
            x.val = val;
            x.leaf = true;
        }
        return x;
    }

    public final Double get(char[] a) {
        if (a == null) throw new NullPointerException();
        Node x = get(root, a, 0);
        return x == null || !x.leaf ? null : x.val;
    }

    public final Iterable<Double> getAll() {
        return get(root(), false);
    }

    protected final Iterable<Double> get(Node x, boolean prefix) {
        if (x == null) return Collections.emptyList();
        DLinkedQueue queue = DLinkedQueue.of();
        LLinkedStack<Node> stack = LLinkedStack.of();
        if (x.mid != null) stack.push(x.mid());
        if (!prefix) {
            if (x.left != null) stack.push(x.left());
            if (x.right != null) stack.push(x.right());
        }
        while (stack.size() > 0) {
            Node pop = stack.pop();
            if (pop.leaf) queue.offer(pop.val);
            push(stack, pop);
        }
        return queue.isEmpty() ? Collections.emptyList() : queue;
    }

    private void push(LLinkedStack<Node> stack, Node x) {
        if (x.left != null) stack.push(x.left());
        if (x.mid != null) stack.push(x.mid());
        if (x.right != null) stack.push(x.right());
    }

    public final Iterable<Double> getByPrefix(char[] prefix) {
        if (prefix == null) throw new NullPointerException();
        Node x = get(root, prefix, 0);
        if (x == null) return Collections.emptyList();
        return get(x, true);
    }

    public final Iterable<char[]> getChars(Predicate<Double> predicate, int limit) {
        return getChars0(x -> predicate == null || predicate.test(((Node) x).val), limit);
    }
}
