package shz.st.tst;

import shz.queue.LLinkedQueue;
import shz.stack.LLinkedStack;

import java.util.Collections;
import java.util.function.Predicate;

/**
 * 值为E类型的TST
 * <p>
 * 8+[51+E(类型字节)+对齐填充]*n(n为元素个数)
 * <p>
 * B=24+48*n+(3+E+对齐填充)*n
 */
public class LTST<E> extends TST {
    /**
     * 8+E(类型字节)+27+对齐填充
     * <p>
     * B=51+E(类型字节)+对齐填充
     * <p>
     * 若E为String,则B=41+64+2*n(n为字符串长度)=105+2*n+对齐填充
     * 三向单词查找树相比常规单词查找树可节省内存消耗而且不受字母表大小的限制
     */
    protected static final class Node<E> extends TST.Node {
        public E val;

        public Node(char c) {
            super(c);
        }
    }

    protected LTST() {
    }

    public static <E> LTST<E> of() {
        return new LTST<>();
    }

    public final void put(char[] a, E val) {
        if (a == null || val == null) throw new NullPointerException();
        root = put(root(), a, val, 0);
    }

    protected final Node<E> put(Node<E> x, char[] a, E val, int d) {
        if (x == null) x = new Node<>(a[d]);
        if (a[d] < x.c) x.left = put(x.left(), a, val, d);
        else if (a[d] > x.c) x.right = put(x.right(), a, val, d);
        else if (d < a.length - 1) x.mid = put(x.mid(), a, val, d + 1);
        else {
            x.val = val;
            x.leaf = true;
        }
        return x;
    }

    public final E get(char[] a) {
        if (a == null) throw new NullPointerException();
        Node<E> x = get(root, a, 0);
        return x == null || !x.leaf ? null : x.val;
    }

    public final Iterable<E> getAll() {
        return get(root(), false);
    }

    protected final Iterable<E> get(Node<E> x, boolean prefix) {
        if (x == null) return Collections.emptyList();
        LLinkedQueue<E> queue = LLinkedQueue.of();
        LLinkedStack<Node<E>> stack = LLinkedStack.of();
        if (x.mid != null) stack.push(x.mid());
        if (!prefix) {
            if (x.left != null) stack.push(x.left());
            if (x.right != null) stack.push(x.right());
        }
        while (stack.size() > 0) {
            Node<E> pop = stack.pop();
            if (pop.leaf) queue.offer(pop.val);
            push(stack, pop);
        }
        return queue.isEmpty() ? Collections.emptyList() : queue;
    }

    private void push(LLinkedStack<Node<E>> stack, Node<E> x) {
        if (x.left != null) stack.push(x.left());
        if (x.mid != null) stack.push(x.mid());
        if (x.right != null) stack.push(x.right());
    }

    public final Iterable<E> getByPrefix(char[] prefix) {
        if (prefix == null) throw new NullPointerException();
        Node<E> x = get(root, prefix, 0);
        if (x == null) return Collections.emptyList();
        return get(x, true);
    }

    @SuppressWarnings("unchecked")
    public final Iterable<char[]> getChars(Predicate<E> predicate, int limit) {
        return getChars0(x -> predicate == null || predicate.test(((Node<E>) x).val), limit);
    }
}
