package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为byte基于动态数组的栈
 * <p>
 * 24+n(n为元素个数)=es
 * <p>
 * B=48+n+对齐填充
 */
public class BArrayStack extends ArrayStack<Byte> {
    protected byte[] es;

    protected BArrayStack(int capacity) {
        super(capacity);
        es = new byte[capacity];
    }

    public static BArrayStack of(int capacity) {
        return new BArrayStack(capacity);
    }

    public static BArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Byte get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void push(byte e) {
        beforePush();
        es[size++] = e;
    }

    public final byte pop() {
        byte e = es[--size];
        afterPop();
        return e;
    }

    public final byte peek() {
        return es[size - 1];
    }
}
