package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为char基于动态数组的栈
 * <p>
 * 24+2*n(n为元素个数)=es
 * <p>
 * B=48+2*n+对齐填充
 */
public class CArrayStack extends ArrayStack<Character> {
    protected char[] es;

    protected CArrayStack(int capacity) {
        super(capacity);
        es = new char[capacity];
    }

    public static CArrayStack of(int capacity) {
        return new CArrayStack(capacity);
    }

    public static CArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Character get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void push(char e) {
        beforePush();
        es[size++] = e;
    }

    public final char pop() {
        char e = es[--size];
        afterPop();
        return e;
    }

    public final char peek() {
        return es[size - 1];
    }
}
