package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为double基于动态数组的栈
 * <p>
 * 24+8*n(n为元素个数)=es
 * <p>
 * B=48+8*n
 */
public class DArrayStack extends ArrayStack<Double> {
    protected double[] es;

    protected DArrayStack(int capacity) {
        super(capacity);
        es = new double[capacity];
    }

    public static DArrayStack of(int capacity) {
        return new DArrayStack(capacity);
    }

    public static DArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Double get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0d;
    }

    public final void push(double e) {
        beforePush();
        es[size++] = e;
    }

    public final double pop() {
        double e = es[--size];
        afterPop();
        return e;
    }

    public final double peek() {
        return es[size - 1];
    }
}
