package shz.stack;

import shz.linked.DSNode;
import shz.linked.SNode;

/**
 * 元素类型为double基于链表的栈
 * <p>
 * 12+16*(n+1)(n为元素个数)
 * <p>
 * B=16*(n+3)
 */
public class DLinkedStack extends LinkedStack<Double> {
    protected DLinkedStack() {
    }

    public static DLinkedStack of() {
        return new DLinkedStack();
    }

    @Override
    protected final Double get(SNode node) {
        return ((DSNode) node).val;
    }

    public final void push(double e) {
        SNode temp = head;
        head = DSNode.of(e);
        head.next(temp);
        ++size;
    }

    public final double pop() {
        double val = peek();
        head = head.next();
        --size;
        return val;
    }

    public final double peek() {
        return ((DSNode) head).val;
    }
}
