package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为float基于动态数组的栈
 * <p>
 * 24+4*n(n为元素个数)=es
 * <p>
 * B=48+4*n+对齐填充
 */
public class FArrayStack extends ArrayStack<Float> {
    protected float[] es;

    protected FArrayStack(int capacity) {
        super(capacity);
        es = new float[capacity];
    }

    public static FArrayStack of(int capacity) {
        return new FArrayStack(capacity);
    }

    public static FArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Float get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0f;
    }

    public final void push(float e) {
        beforePush();
        es[size++] = e;
    }

    public final float pop() {
        float e = es[--size];
        afterPop();
        return e;
    }

    public final float peek() {
        return es[size - 1];
    }
}
