package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为int基于动态数组的栈
 * <p>
 * 24+4*n(n为元素个数)=es
 * <p>
 * B=48+4*n+对齐填充
 */
public class IArrayStack extends ArrayStack<Integer> {
    protected int[] es;

    protected IArrayStack(int capacity) {
        super(capacity);
        es = new int[capacity];
    }

    public static IArrayStack of(int capacity) {
        return new IArrayStack(capacity);
    }

    public static IArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Integer get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void push(int e) {
        beforePush();
        es[size++] = e;
    }

    public final int pop() {
        int e = es[--size];
        afterPop();
        return e;
    }

    public final int peek() {
        return es[size - 1];
    }
}
