package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为long基于动态数组的栈
 * <p>
 * 24+8*n(n为元素个数)=es
 * <p>
 * B=48+8*n
 */
public class JArrayStack extends ArrayStack<Long> {
    protected long[] es;

    protected JArrayStack(int capacity) {
        super(capacity);
        es = new long[capacity];
    }

    public static JArrayStack of(int capacity) {
        return new JArrayStack(capacity);
    }

    public static JArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Long get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0L;
    }

    public final void push(long e) {
        beforePush();
        es[size++] = e;
    }

    public final long pop() {
        long e = es[--size];
        afterPop();
        return e;
    }

    public final long peek() {
        return es[size - 1];
    }
}
