package shz.stack;

import shz.linked.JSNode;
import shz.linked.SNode;

/**
 * 元素类型为long基于链表的栈
 * <p>
 * 12+16*(n+1)(n为元素个数)
 * <p>
 * B=16*(n+3)
 */
public class JLinkedStack extends LinkedStack<Long> {
    protected JLinkedStack() {
    }

    public static JLinkedStack of() {
        return new JLinkedStack();
    }

    @Override
    protected final Long get(SNode node) {
        return ((JSNode) node).val;
    }

    public final void push(long e) {
        SNode temp = head;
        head = JSNode.of(e);
        head.next(temp);
        ++size;
    }

    public final long pop() {
        long val = peek();
        head = head.next();
        --size;
        return val;
    }

    public final long peek() {
        return ((JSNode) head).val;
    }
}
