package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为E基于动态数组的栈
 * <p>
 * 24+[8+E(类型字节)]*n(n为元素个数)=es
 * <p>
 * B=48+8*n+(E*n+对齐填充)
 */
@SuppressWarnings("unchecked")
public class LArrayStack<E> extends ArrayStack<E> {
    protected E[] es;

    protected LArrayStack(int capacity) {
        super(capacity);
        es = (E[]) new Object[capacity];
    }

    public static <E> LArrayStack<E> of(int capacity) {
        return new LArrayStack<>(capacity);
    }

    public static <E> LArrayStack<E> of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final E get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = null;
    }

    public final void push(E e) {
        beforePush();
        es[size++] = e;
    }

    public final E pop() {
        E e = es[--size];
        afterPop();
        return e;
    }

    public final E peek() {
        return es[size - 1];
    }
}
