package shz.stack;

import shz.linked.LSNode;
import shz.linked.SNode;

/**
 * 元素类型为E基于链表的栈
 * <p>
 * 12+16*(n+1)+(E+对齐填充)*n(n为元素个数)
 * <p>
 * B=16*(n+3)+(E+对齐填充)*n
 */
@SuppressWarnings("unchecked")
public class LLinkedStack<E> extends LinkedStack<E> {
    protected LLinkedStack() {
    }

    public static <E> LLinkedStack<E> of() {
        return new LLinkedStack<>();
    }

    @Override
    protected final E get(SNode node) {
        return ((LSNode<E>) node).val;
    }

    public final void push(E e) {
        SNode temp = head;
        head = LSNode.of(e);
        head.next(temp);
        ++size;
    }

    public final E pop() {
        E val = get(head);
        head = head.next();
        --size;
        return val;
    }

    public final E peek() {
        return get(head);
    }
}
