package shz.stack;

import shz.linked.SNode;

import java.util.Iterator;

/**
 * 基于链表的栈
 */
public abstract class LinkedStack<E> implements Iterable<E> {
    protected SNode head;
    protected int size;

    protected LinkedStack() {
    }

    public final class LinkedStackIterator implements Iterator<E> {
        private SNode current = head;

        @Override
        public boolean hasNext() {
            return current != null;
        }

        @Override
        public E next() {
            E val = get(current);
            current = current.next();
            return val;
        }
    }

    protected abstract E get(SNode node);

    @Override
    public Iterator<E> iterator() {
        return new LinkedStackIterator();
    }

    public int size() {
        return size;
    }

    public boolean isEmpty() {
        return head == null;
    }
}
