package shz.stack;

import java.util.Arrays;

/**
 * 元素类型为short基于动态数组的栈
 * <p>
 * 24+2*n(n为元素个数)=es
 * <p>
 * B=48+2*n+对齐填充
 */
public class SArrayStack extends ArrayStack<Short> {
    protected short[] es;

    protected SArrayStack(int capacity) {
        super(capacity);
        es = new short[capacity];
    }

    public static SArrayStack of(int capacity) {
        return new SArrayStack(capacity);
    }

    public static SArrayStack of() {
        return of(DEFAULT_CAPACITY);
    }

    @Override
    protected final Short get(int i) {
        return es[i];
    }

    @Override
    protected final void resize(int capacity) {
        this.capacity = capacity;
        es = Arrays.copyOf(es, capacity);
    }

    @Override
    protected final void setNull(int i) {
        es[i] = 0;
    }

    public final void push(short e) {
        beforePush();
        es[size++] = e;
    }

    public final short pop() {
        short e = es[--size];
        afterPop();
        return e;
    }

    public final short peek() {
        return es[size - 1];
    }
}
