package shz.third;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * http请求参数配置注解
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ApiConfig {
    String url();

    String method() default "GET";

    String proxyHost() default "";

    String proxyPort() default "0";

    String connectTimeoutMills() default "10000";

    String readTimeoutMills() default "10000";
}
