/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import shz.FileHelp;
import shz.IOHelp;
import shz.PRException;
import shz.ToList;
import shz.Validator;
import shz.constant.ArrayConstant;
import shz.constant.NullConstant;
import shz.enums.IEnum;
import shz.msg.ServerFailure;
import shz.queue.IArrayQueue;

public final class AccessibleHelp {
    private static final Map<Class<?>, Map<Class<?>, Map<String, Class<?>>>> PARAMETERIZED_TYPE_CACHE = new ConcurrentHashMap(128);
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentHashMap(128);
    private static final Map<Class<?>, List<String>> FIELD_NAME_CACHE = new ConcurrentHashMap(128);
    private static final Map<Class<?>, List<Constructor<?>>> CONSTRUCTOR_CACHE = new ConcurrentHashMap(128);
    private static final Map<Class<?>, List<Method>> METHOD_CACHE = new ConcurrentHashMap(128);
    private static final Map<Class<?>, List<?>> ENUM_CACHE = new ConcurrentHashMap(128);
    private static final Map<String, Class<?>> ENUM_TYPE_CLASS_CACHE = new ConcurrentHashMap(128);

    private AccessibleHelp() {
        throw new IllegalStateException();
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader loader) {
        if (Validator.isBlank(className)) {
            return null;
        }
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            if (initialize && loader == null) {
                return Class.forName(className);
            }
            return Class.forName(className, initialize, loader == null ? Thread.currentThread().getContextClassLoader() : loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> forName(String className, boolean initialize) {
        return AccessibleHelp.forName(className, initialize, null);
    }

    public static Class<?> forName(String className) {
        return AccessibleHelp.forName(className, false, null);
    }

    public static boolean isPrimitive(Class<?> cls) {
        if (cls == null || cls == Void.TYPE) {
            return false;
        }
        return cls.isPrimitive();
    }

    public static boolean isPrimitiveWrap(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Double.class || cls == Float.class;
    }

    public static boolean isCommon(Class<?> cls) {
        if (cls == null || cls == Void.class || cls == Void.TYPE) {
            return false;
        }
        return cls.isPrimitive() || cls == Boolean.class || cls == Character.class || CharSequence.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls) || TemporalAccessor.class.isAssignableFrom(cls) || TemporalAdjuster.class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls) || Enum.class.isAssignableFrom(cls);
    }

    public static boolean canCast(Class<?> src, Class<?> des) {
        boolean desIsPw;
        if (src == null || des == null) {
            return false;
        }
        boolean srcIsP = src.isPrimitive();
        boolean srcIsPw = !srcIsP && AccessibleHelp.isPrimitiveWrap(src);
        boolean desIsP = des.isPrimitive();
        boolean bl = desIsPw = !desIsP && AccessibleHelp.isPrimitiveWrap(des);
        if ((srcIsP | srcIsPw) ^ (desIsP | desIsPw)) {
            return false;
        }
        if (!(srcIsP | srcIsPw | desIsP | desIsPw)) {
            return des.isAssignableFrom(src);
        }
        String desName = des.getTypeName();
        switch (src.getTypeName()) {
            case "java.lang.Boolean": 
            case "boolean": {
                return desName.endsWith("n");
            }
            case "java.lang.Byte": 
            case "byte": {
                return desName.endsWith("te");
            }
            case "java.lang.Character": 
            case "char": {
                return desName.endsWith("ter") || desName.endsWith("ar");
            }
            case "java.lang.Short": 
            case "short": {
                return desName.endsWith("rt");
            }
            case "java.lang.Integer": 
            case "int": {
                return desName.endsWith("ger") || desName.endsWith("nt");
            }
            case "java.lang.Long": 
            case "long": {
                return desName.endsWith("g");
            }
            case "java.lang.Double": 
            case "double": {
                return desName.endsWith("le");
            }
            case "java.lang.Float": 
            case "float": {
                return desName.endsWith("at");
            }
            case "java.lang.Void": 
            case "void": {
                return desName.endsWith("d");
            }
        }
        return false;
    }

    public static <T> Class<T> getParameterizedType(Class<?> cls, Class<?> superOrInterface, String typeParamName) {
        Map typeParamNameMap = PARAMETERIZED_TYPE_CACHE.computeIfAbsent(cls, k -> new ConcurrentHashMap(128));
        Map clsMap = typeParamNameMap.computeIfAbsent(superOrInterface, k -> new ConcurrentHashMap(128));
        return clsMap.computeIfAbsent(typeParamName, k -> AccessibleHelp.getParameterizedType0(cls, superOrInterface, typeParamName));
    }

    private static Class<?> getParameterizedType0(Class<?> cls, Class<?> superOrInterface, String typeParamName) {
        block11: {
            Object d;
            Class<?> cur = cls;
            do {
                if ((cur = AccessibleHelp.oneTopChild(cur, superOrInterface)) == null) {
                    return Object.class;
                }
                int idx = -1;
                TypeVariable<Class<?>>[] typeParams = superOrInterface.getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    idx = i;
                    break;
                }
                if (idx < 0) {
                    return Object.class;
                }
                Type genericSuperType = null;
                if (superOrInterface.isInterface()) {
                    for (Type type : cur.getGenericInterfaces()) {
                        if (AccessibleHelp.tryToClass(type) != superOrInterface) continue;
                        genericSuperType = type;
                        break;
                    }
                } else {
                    genericSuperType = cur.getGenericSuperclass();
                }
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[idx];
                Class<?> result = AccessibleHelp.tryToClass(actualTypeParam);
                if (result != null) {
                    return result;
                }
                if (!(actualTypeParam instanceof TypeVariable)) break block11;
                cur = cls;
                TypeVariable v = (TypeVariable)actualTypeParam;
                d = v.getGenericDeclaration();
                if (!(d instanceof Class)) {
                    return Object.class;
                }
                typeParamName = v.getName();
            } while ((superOrInterface = (Class)d).isAssignableFrom(cls));
            return Object.class;
        }
        return Object.class;
    }

    private static Class<?> oneTopChild(Class<?> c, Class<?> p) {
        if (c == null || c == Object.class) {
            return null;
        }
        Class<?> cur = c;
        while (true) {
            Class<?> sup;
            if ((sup = cur.getSuperclass()) == p) {
                return cur;
            }
            if (sup == null || !p.isAssignableFrom(sup)) break;
            cur = sup;
        }
        c = null;
        for (Class<?> cls : cur.getInterfaces()) {
            if (cls == p) {
                return cur;
            }
            if (c != null || !p.isAssignableFrom(cls)) continue;
            c = cls;
        }
        return AccessibleHelp.oneTopChild(c, p);
    }

    private static Class<?> tryToClass(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (componentType instanceof ParameterizedType) {
                componentType = ((ParameterizedType)componentType).getRawType();
            }
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
        }
        return null;
    }

    public static Type[] getTypes(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments();
        }
        return (Type[])Validator.empty(Type[].class);
    }

    public static Type[] getTypes(Class<?> cls) {
        if (cls == null) {
            return (Type[])Validator.empty(Type[].class);
        }
        Type genericSuperType = null;
        if (cls.isInterface()) {
            Type type;
            Type[] typeArray = cls.getGenericInterfaces();
            int n = typeArray.length;
            for (int i = 0; i < n && !((genericSuperType = (type = typeArray[i])) instanceof ParameterizedType); ++i) {
            }
        } else {
            genericSuperType = cls.getGenericSuperclass();
        }
        if (genericSuperType instanceof ParameterizedType) {
            return ((ParameterizedType)genericSuperType).getActualTypeArguments();
        }
        return (Type[])Validator.empty(Type[].class);
    }

    public static Class<?> typeToClass(Type type) {
        TypeVariable v;
        if (type == null) {
            return null;
        }
        Class<?> cls = AccessibleHelp.tryToClass(type);
        if (cls != null) {
            return cls;
        }
        if (type instanceof TypeVariable && !((v = (TypeVariable)type).getGenericDeclaration() instanceof Class)) {
            return Object.class;
        }
        return AccessibleHelp.forName(type.getTypeName());
    }

    public static Class<?>[] typeToClass(Type[] types, int ... indexes) {
        if (Validator.isEmpty(types)) {
            return ArrayConstant.EMPTY_CLASS_ARRAY;
        }
        Validator.requireNon(types.length < indexes.length);
        Type[] result = new Type[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            Validator.requireNon(indexes[i] < 0 || indexes[i] >= types.length);
            result[i] = types[indexes[i]];
        }
        return (Class[])Arrays.stream(result).map(AccessibleHelp::typeToClass).toArray(Class[]::new);
    }

    public static String identify(Class<?> cls) {
        if (cls == null) {
            return NullConstant.STRING;
        }
        Type[] types = AccessibleHelp.getTypes(cls);
        if (types.length == 0) {
            return cls.getName();
        }
        StringBuilder sb = new StringBuilder(cls.getName());
        HashSet exists = new HashSet();
        Arrays.stream(types).map(AccessibleHelp::typeToClass).filter(Objects::nonNull).forEach(c -> AccessibleHelp.identify0(c, sb, exists, 1));
        return sb.toString();
    }

    private static void identify0(Class<?> cls, StringBuilder sb, Set<Class<?>> exists, int nest) {
        Type[] types = AccessibleHelp.getTypes(cls);
        if (types.length == 0) {
            sb.append("-").append(cls.getName()).append(nest);
        } else {
            Arrays.stream(types).map(AccessibleHelp::typeToClass).filter(Objects::nonNull).forEach(c -> {
                if (exists.contains(c)) {
                    sb.append("-").append(c.getName()).append(nest + 1);
                } else {
                    exists.add((Class<?>)c);
                    AccessibleHelp.identify0(c, sb, exists, nest + 1);
                }
            });
        }
    }

    public static Field accessible(Field field) {
        if (field.isAccessible()) {
            return field;
        }
        if ((field.getModifiers() & 1) == 0 || (field.getDeclaringClass().getModifiers() & 1) == 0 || (field.getModifiers() & 0x10) != 0) {
            field.setAccessible(true);
        }
        return field;
    }

    public static <T> Constructor<T> accessible(Constructor<T> constructor) {
        if (constructor.isAccessible()) {
            return constructor;
        }
        if ((constructor.getModifiers() & 1) == 0 || (constructor.getDeclaringClass().getModifiers() & 1) == 0) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static Method accessible(Method method) {
        if (method.isAccessible()) {
            return method;
        }
        if ((method.getModifiers() & 1) == 0 || (method.getDeclaringClass().getModifiers() & 1) == 0) {
            method.setAccessible(true);
        }
        return method;
    }

    public static List<Field> fields(Class<?> cls, Predicate<Field> predicate, int limit) {
        if (cls == null || predicate == null) {
            return Collections.emptyList();
        }
        List result = FIELD_CACHE.computeIfAbsent(cls, k -> {
            LinkedList fields = new LinkedList();
            Class cur = cls;
            do {
                Arrays.stream(cur.getDeclaredFields()).map(AccessibleHelp::accessible).forEach(fields::add);
            } while ((cur = cur.getSuperclass()) != null && cur != Object.class);
            return fields.isEmpty() ? Collections.emptyList() : new ArrayList(fields);
        });
        return AccessibleHelp.collect(result, predicate, limit);
    }

    private static <T> List<T> collect(List<T> result, Predicate<T> predicate, int limit) {
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        Stream stream = result.stream().filter(predicate);
        if (limit > 0) {
            return ToList.explicitCollect(stream.limit(limit), limit);
        }
        return ToList.collectArray(stream);
    }

    public static List<Field> fields(Class<?> cls, Predicate<Field> predicate) {
        return AccessibleHelp.fields(cls, predicate, 0);
    }

    public static List<Field> fields(Class<?> cls) {
        return AccessibleHelp.fields(cls, f -> (f.getModifiers() & 8) == 0, 0);
    }

    public static List<String> fieldNames(Class<?> cls, Predicate<String> predicate, int limit) {
        if (cls == null || predicate == null) {
            return Collections.emptyList();
        }
        List result = FIELD_NAME_CACHE.computeIfAbsent(cls, k -> {
            List<Field> fields = AccessibleHelp.fields(cls);
            return fields.isEmpty() ? Collections.emptyList() : ToList.explicitCollect(fields.stream().map(Field::getName), fields.size());
        });
        return AccessibleHelp.collect(result, predicate, limit);
    }

    public static List<String> fieldNames(Class<?> cls, Predicate<String> predicate) {
        return AccessibleHelp.fieldNames(cls, predicate, 0);
    }

    public static List<String> fieldNames(Class<?> cls) {
        return AccessibleHelp.fieldNames(cls, f -> true, 0);
    }

    public static List<Constructor<?>> constructors(Class<?> cls, Predicate<Constructor<?>> predicate, int limit) {
        if (cls == null || predicate == null) {
            return Collections.emptyList();
        }
        List result = CONSTRUCTOR_CACHE.computeIfAbsent(cls, k -> {
            LinkedList constructors = new LinkedList();
            Class cur = cls;
            do {
                Arrays.stream(cur.getDeclaredConstructors()).map(AccessibleHelp::accessible).forEach(constructors::add);
            } while ((cur = cur.getSuperclass()) != null && cur != Object.class);
            return constructors.isEmpty() ? Collections.emptyList() : new ArrayList(constructors);
        });
        return AccessibleHelp.collect(result, predicate, limit);
    }

    public static List<Constructor<?>> constructors(Class<?> cls, Predicate<Constructor<?>> predicate) {
        return AccessibleHelp.constructors(cls, predicate, 0);
    }

    public static List<Constructor<?>> constructors(Class<?> cls) {
        return AccessibleHelp.constructors(cls, f -> true, 0);
    }

    public static List<Method> methods(Class<?> cls, Predicate<Method> predicate, int limit) {
        if (cls == null || predicate == null) {
            return Collections.emptyList();
        }
        List result = METHOD_CACHE.computeIfAbsent(cls, k -> {
            LinkedList methods = new LinkedList();
            Class cur = cls;
            do {
                Arrays.stream(cur.getDeclaredMethods()).map(AccessibleHelp::accessible).forEach(methods::add);
            } while ((cur = cur.getSuperclass()) != null && cur != Object.class);
            return methods.isEmpty() ? Collections.emptyList() : new ArrayList(methods);
        });
        return AccessibleHelp.collect(result, predicate, limit);
    }

    public static List<Method> methods(Class<?> cls, Predicate<Method> predicate) {
        return AccessibleHelp.methods(cls, predicate, 0);
    }

    public static List<Method> methods(Class<?> cls) {
        return AccessibleHelp.methods(cls, f -> !Modifier.isStatic(f.getModifiers()), 0);
    }

    public static Method getMethod(Class<?> cls, String methodName) {
        List<Method> methods = AccessibleHelp.methods(cls, m -> m.getName().equals(methodName) && m.getParameterCount() == 0, 1);
        Validator.requireNonEmpty(methods);
        return methods.get(0);
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ptype) {
        List<Method> methods = AccessibleHelp.methods(cls, m -> {
            if (!m.getName().equals(methodName)) {
                return false;
            }
            Class<?>[] ptypes = m.getParameterTypes();
            return ptypes.length == 1 && ptypes[0].isAssignableFrom(ptype);
        }, 0);
        Validator.requireNonEmpty(methods);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        Class[] pa = (Class[])methods.stream().map(m -> m.getParameterTypes()[0]).toArray(Class[]::new);
        int idx = 0;
        for (int i = 1; i < pa.length && pa[idx] != ptype; ++i) {
            if (!pa[idx].isAssignableFrom(pa[i])) continue;
            idx = i;
        }
        return methods.get(idx);
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ptype1, Class<?> ptype2) {
        List<Method> methods = AccessibleHelp.methods(cls, m -> {
            if (!m.getName().equals(methodName)) {
                return false;
            }
            Class<?>[] ptypes = m.getParameterTypes();
            return ptypes.length == 2 && ptypes[0].isAssignableFrom(ptype1) && ptypes[1].isAssignableFrom(ptype2);
        }, 0);
        Validator.requireNonEmpty(methods);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        Class[][] psa = (Class[][])methods.stream().map(Method::getParameterTypes).toArray(x$0 -> new Class[x$0][]);
        return methods.get(AccessibleHelp.match(psa, ptype1, ptype2));
    }

    private static int match(Class<?>[][] psa, Class<?> ... ptypes) {
        int mlen = psa.length;
        int j = 0;
        IArrayQueue ia = IArrayQueue.of(mlen);
        for (int i = 0; i < mlen; ++i) {
            ia.offer(i);
        }
        while (j < ptypes.length - 1) {
            IArrayQueue nia = IArrayQueue.of(mlen);
            for (int k = 0; k < mlen; ++k) {
                int i = ia.poll();
                if (psa[i][j] == ptypes[j]) {
                    ia.offer(i);
                    continue;
                }
                nia.offer(i);
            }
            mlen = ia.size();
            if (mlen == 1) {
                return ia.poll();
            }
            if (mlen == 0) {
                int nmlen = nia.size();
                Class<?> cls = psa[nia.head()][j];
                nia.offer(nia.poll());
                for (int k = 1; k < nmlen; ++k) {
                    int i = nia.poll();
                    if (!cls.isAssignableFrom(psa[i][j])) continue;
                    nia.offer(i);
                    cls = psa[i][j];
                }
                if (nia.size() == 1) {
                    return nia.poll();
                }
                while (!nia.isEmpty()) {
                    int i = nia.poll();
                    if (psa[i][j] != cls) continue;
                    ia.offer(i);
                }
                mlen = ia.size();
                if (mlen == 1) {
                    return ia.poll();
                }
            }
            ++j;
        }
        int idx = ia.poll();
        if (psa[idx][j] == ptypes[j]) {
            return idx;
        }
        while (!ia.isEmpty()) {
            int i = ia.poll();
            if (psa[i][j] == ptypes[j]) {
                return i;
            }
            if (!psa[idx][j].isAssignableFrom(psa[i][j])) continue;
            idx = i;
        }
        return idx;
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... ptypes) {
        List<Method> methods = AccessibleHelp.methods(cls, m -> {
            if (!m.getName().equals(methodName)) {
                return false;
            }
            Class<?>[] pTypes = m.getParameterTypes();
            if (pTypes.length != ptypes.length) {
                return false;
            }
            for (int i = 0; i < pTypes.length; ++i) {
                if (pTypes[i].isAssignableFrom(ptypes[i])) continue;
                return false;
            }
            return true;
        }, 0);
        Validator.requireNonEmpty(methods);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        Class[][] psa = (Class[][])methods.stream().map(Method::getParameterTypes).toArray(x$0 -> new Class[x$0][]);
        return methods.get(AccessibleHelp.match(psa, ptypes));
    }

    public static ClassLoader getClassLoader(Function<String, InputStream> classIs) {
        if (classIs == null) {
            return null;
        }
        return new CustomClassLoader(name -> IOHelp.read((InputStream)classIs.apply((String)name)));
    }

    public static ClassLoader getClassLoader(Function<String, InputStream> classIs, Function<byte[], byte[]> modifier) {
        if (classIs == null) {
            return null;
        }
        return new CustomClassLoader(name -> (byte[])modifier.apply(IOHelp.read((InputStream)classIs.apply((String)name))));
    }

    @SafeVarargs
    public static ClassLoader getClassLoader(Function<String, InputStream> classIs, Function<byte[], byte[]> ... modifiers) {
        if (classIs == null) {
            return null;
        }
        return new CustomClassLoader(name -> {
            Function modifier = modifiers[0];
            for (int i = 1; i < modifiers.length; ++i) {
                modifier = modifier.andThen(modifiers[i]);
            }
            return (byte[])modifier.apply(IOHelp.read((InputStream)classIs.apply((String)name)));
        });
    }

    public static ClassLoader getClassLoader(String classpath) {
        return AccessibleHelp.getClassLoader((String t) -> AccessibleHelp.getLocalClassIs(classpath, t));
    }

    public static InputStream getLocalClassIs(String classpath, String name) {
        if (Validator.isBlank(name)) {
            return null;
        }
        String path = name.replace('.', '/') + ".class";
        try {
            return IOHelp.getBis(Validator.isBlank(classpath) ? new File(FileHelp.fromUrl(Thread.currentThread().getContextClassLoader().getResource("")), path) : new File(classpath, path));
        }
        catch (Throwable t) {
            try {
                return IOHelp.getIsFromURL(path);
            }
            catch (Throwable cause) {
                return null;
            }
        }
    }

    public static ClassLoader getClassLoader(String classpath, Function<byte[], byte[]> modifier) {
        return AccessibleHelp.getClassLoader((String name) -> AccessibleHelp.getLocalClassIs(classpath, name), modifier);
    }

    @SafeVarargs
    public static ClassLoader getClassLoader(String classpath, Function<byte[], byte[]> ... modifiers) {
        return AccessibleHelp.getClassLoader((String name) -> AccessibleHelp.getLocalClassIs(classpath, name), modifiers);
    }

    public static <T> List<Class<? super T>> getSuperClasses(Class<T> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        for (Class<T> cur = cls.getSuperclass(); cur != Object.class; cur = cur.getSuperclass()) {
            result.add(cur);
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public static List<Class<?>> getInnerClasses(Class<?> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        LinkedList<Class<?>[]> queue = new LinkedList<Class<?>[]>();
        queue.offer(cls.getDeclaredClasses());
        while (queue.size() > 0) {
            for (Class c : (Class[])queue.poll()) {
                result.add(c);
                queue.offer(c.getDeclaredClasses());
            }
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate, int limit, String packageName) {
        Enumeration<URL> resources;
        if (predicate == null || packageName == null) {
            return Collections.emptyList();
        }
        String packagePath = packageName.replace('.', '/');
        try {
            resources = Thread.currentThread().getContextClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        packageName = "".equals(packageName) ? "" : packageName + ".";
        LinkedList result = new LinkedList();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                try {
                    AccessibleHelp.getClassesFromFile(predicate, limit, packageName, new File(URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8.name())), result);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if ("jar".equals(protocol)) {
                try {
                    AccessibleHelp.getClassesFromJarFile(predicate, limit, packageName, ((JarURLConnection)url.openConnection()).getJarFile(), packagePath, result);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (limit <= 0 || result.size() < limit) continue;
            break;
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private static void getClassesFromFile(Predicate<Class<?>> predicate, int limit, String packageName, File file, List<Class<?>> result) {
        Object[] files = file.listFiles(f -> f.isDirectory() || f.getName().endsWith(".class"));
        if (Validator.isEmpty(files)) {
            return;
        }
        for (Object f2 : files) {
            if (((File)f2).isDirectory()) {
                AccessibleHelp.getClassesFromFile(predicate, limit, packageName + ((File)f2).getName() + ".", (File)f2, result);
                continue;
            }
            try {
                Class<?> forName = AccessibleHelp.forName(packageName + ((File)f2).getName().substring(0, ((File)f2).getName().length() - 6), false, null);
                if (!predicate.test(forName)) continue;
                result.add(forName);
                if (limit <= 0 || result.size() < limit) continue;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void getClassesFromJarFile(Predicate<Class<?>> predicate, int limit, String packageName, JarFile jarFile, String packagePath, List<Class<?>> result) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            name = name.charAt(0) == '/' ? name.substring(1) : name;
            if (!name.startsWith(packagePath)) continue;
            int last = name.lastIndexOf(47);
            String string = packageName = last != -1 ? name.substring(0, last).replace('/', '.') + '.' : packageName;
            if (!name.endsWith(".class") || entry.isDirectory()) continue;
            try {
                Class<?> forName = AccessibleHelp.forName(packageName + name.substring(packageName.length(), name.length() - 6), false, null);
                if (!predicate.test(forName)) continue;
                result.add(forName);
                if (limit <= 0 || result.size() < limit) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate, int limit) {
        return AccessibleHelp.getClasses(predicate, limit, "");
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate, String packageName) {
        return AccessibleHelp.getClasses(predicate, 0, packageName);
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate) {
        return AccessibleHelp.getClasses(predicate, 0, "");
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate, int limit, String ... packageNames) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        for (String name : packageNames) {
            if (Validator.isBlank(name)) continue;
            if (limit > 0) {
                if (result.size() >= limit) break;
                result.addAll(AccessibleHelp.getClasses(predicate, limit - result.size(), name));
                continue;
            }
            result.addAll(AccessibleHelp.getClasses(predicate, limit, name));
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public static List<Class<?>> getClasses(Predicate<Class<?>> predicate, String ... packageNames) {
        return AccessibleHelp.getClasses(predicate, 0, packageNames);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate, int limit, String packageName) {
        if (cls == null || predicate == null || packageName == null) {
            return Collections.emptyList();
        }
        return AccessibleHelp.getClasses((Class<?> c) -> !Modifier.isAbstract(c.getModifiers()) && !Modifier.isInterface(c.getModifiers()) && cls.isAssignableFrom((Class<?>)c) && predicate.test((Class<?>)c), limit, packageName);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate, int limit) {
        return AccessibleHelp.getChildClasses(cls, predicate, limit, "");
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate, String packageName) {
        return AccessibleHelp.getChildClasses(cls, predicate, 0, packageName);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate) {
        return AccessibleHelp.getChildClasses(cls, predicate, 0, "");
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate, int limit, String ... packageNames) {
        if (cls == null || predicate == null) {
            return Collections.emptyList();
        }
        return AccessibleHelp.getClasses((Class<?> c) -> !Modifier.isAbstract(c.getModifiers()) && !Modifier.isInterface(c.getModifiers()) && cls.isAssignableFrom((Class<?>)c) && predicate.test((Class<?>)c), limit, packageNames);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, Predicate<Class<?>> predicate, String ... packageNames) {
        return AccessibleHelp.getChildClasses(cls, predicate, 0, packageNames);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, int limit, String packageName) {
        return AccessibleHelp.getChildClasses(cls, (Class<?> c) -> true, limit, packageName);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, int limit) {
        return AccessibleHelp.getChildClasses(cls, limit, "");
    }

    public static List<Class<?>> getChildClasses(Class<?> cls, String packageName) {
        return AccessibleHelp.getChildClasses(cls, 0, packageName);
    }

    public static List<Class<?>> getChildClasses(Class<?> cls) {
        return AccessibleHelp.getChildClasses(cls, 0, "");
    }

    public static <T> T newObject(Class<? extends T> cls) {
        if (cls == null) {
            return null;
        }
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            return AccessibleHelp.getChildClasses(cls).stream().map(AccessibleHelp::newObject).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (AccessibleHelp.isPrimitive(cls)) {
            if (cls == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            if (cls == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (cls == Character.TYPE) {
                return (T)Character.valueOf('\u0000');
            }
            if (cls == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (cls == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (cls == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (cls == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (cls == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            throw PRException.impossible();
        }
        if (cls == Void.TYPE || cls == Void.class) {
            return null;
        }
        List<Constructor<?>> constructors = AccessibleHelp.constructors(cls, c -> c.getParameterCount() == 0, 1);
        if (constructors.isEmpty()) {
            return null;
        }
        try {
            return (T)constructors.get(0).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    public static <T> T newObject(Class<? extends T> cls, Object initarg) {
        if (cls == null) {
            return null;
        }
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            return AccessibleHelp.getChildClasses(cls).stream().map(c -> AccessibleHelp.newObject(c, initarg)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        for (Constructor<?> constructor : AccessibleHelp.constructors(cls, c -> c.getParameterCount() == 1)) {
            try {
                return (T)constructor.newInstance(initarg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            }
        }
        return null;
    }

    public static <T> T newObject(Class<? extends T> cls, Object ... initargs) {
        if (cls == null) {
            return null;
        }
        if (Modifier.isAbstract(cls.getModifiers()) || Modifier.isInterface(cls.getModifiers())) {
            return AccessibleHelp.getChildClasses(cls).stream().map(c -> AccessibleHelp.newObject(c, initargs)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        for (Constructor<?> constructor : AccessibleHelp.constructors(cls, c -> c.getParameterCount() == initargs.length)) {
            try {
                return (T)constructor.newInstance(initargs);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            }
        }
        return null;
    }

    public static <T> T newObject(String className, ClassLoader classLoader) {
        try {
            return (T)AccessibleHelp.newObject(classLoader == null ? AccessibleHelp.forName(className, true) : classLoader.loadClass(className));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T newObject(String className, ClassLoader classLoader, Object initarg) {
        try {
            return (T)AccessibleHelp.newObject(classLoader == null ? AccessibleHelp.forName(className, true) : classLoader.loadClass(className), initarg);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T newObject(String className, ClassLoader classLoader, Object ... initargs) {
        try {
            return (T)AccessibleHelp.newObject(classLoader == null ? AccessibleHelp.forName(className, true) : classLoader.loadClass(className), initargs);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T newObject(String className, String classpath) {
        return AccessibleHelp.newObject(className, AccessibleHelp.getClassLoader(classpath));
    }

    public static <T> T newObject(String className, String classpath, Object initarg) {
        return AccessibleHelp.newObject(className, AccessibleHelp.getClassLoader(classpath), initarg);
    }

    public static <T> T newObject(String className, String classpath, Object ... initargs) {
        return AccessibleHelp.newObject(className, AccessibleHelp.getClassLoader(classpath), initargs);
    }

    public static <T> T cloneObject(T t) {
        if (t == null) {
            return null;
        }
        Class<?> cls = t.getClass();
        Object obj = AccessibleHelp.newObject(cls);
        Objects.requireNonNull(obj);
        AccessibleHelp.fields(cls).parallelStream().forEach(f -> AccessibleHelp.setField(f, obj, AccessibleHelp.getField(f, t)));
        return (T)obj;
    }

    public static <T> T getField(Field field, Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void setField(Field field, Object obj, Object val) {
        try {
            field.set(obj, val);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static <T extends Enum<T>> List<T> enumSet(Class<?> cls) {
        if (cls == null || !Enum.class.isAssignableFrom(cls)) {
            return Collections.emptyList();
        }
        return ENUM_CACHE.computeIfAbsent(cls, k -> {
            EnumSet enumSet = null;
            try {
                enumSet = EnumSet.allOf(cls);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return enumSet == null ? Collections.emptyList() : ToList.collectArray(enumSet.stream());
        });
    }

    public static <S> List<S> enumSets(Class<S> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        if (!Modifier.isInterface(cls.getModifiers())) {
            return AccessibleHelp.enumSet(cls);
        }
        return ENUM_CACHE.computeIfAbsent(cls, k -> ToList.collectArray(AccessibleHelp.getChildClasses(cls).parallelStream().map(AccessibleHelp::enumSet).filter(Validator::nonEmpty).flatMap(Collection::stream)));
    }

    public static <E extends Enum<E>, T extends IEnum<?, ?>> List<T> enumSet(String typeName) {
        if (Validator.isBlank(typeName)) {
            return Collections.emptyList();
        }
        Class resultCls = ENUM_TYPE_CLASS_CACHE.computeIfAbsent(typeName, k -> {
            List<Class<?>> classes;
            Object cls = typeName.indexOf(".") > 0 ? AccessibleHelp.forName(typeName) : ((classes = AccessibleHelp.getClasses((Class<?> c) -> IEnum.class.isAssignableFrom((Class<?>)c) && c.getSimpleName().equals(typeName), 1)).isEmpty() ? null : classes.get(0));
            return cls == null || !IEnum.class.isAssignableFrom((Class<?>)cls) ? NullConstant.CLASS : cls;
        });
        if (resultCls == NullConstant.CLASS) {
            return Collections.emptyList();
        }
        List<T> ts = AccessibleHelp.enumSet(resultCls);
        if (ts.isEmpty()) {
            return Collections.emptyList();
        }
        return ToList.explicitCollect(ts.stream().map(e -> (IEnum)((Object)e)), ts.size());
    }

    public static <T, U> U invoke(T receiver, String methodName) {
        try {
            Method method = AccessibleHelp.getMethod(receiver.getClass(), methodName);
            if (method.getReturnType() != Void.TYPE) {
                return (U)method.invoke(receiver, new Object[0]);
            }
            method.invoke(receiver, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static <T, U> U invoke(T receiver, String methodName, Class<?> ptype, Object arg) {
        try {
            Method method = AccessibleHelp.getMethod(receiver.getClass(), methodName, ptype);
            if (method.getReturnType() != Void.TYPE) {
                return (U)method.invoke(receiver, arg);
            }
            method.invoke(receiver, arg);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static <T, U> U invoke(T receiver, String methodName, Class<?>[] ptypes, Object[] args) {
        try {
            Method method = AccessibleHelp.getMethod(receiver.getClass(), methodName, ptypes);
            if (method.getReturnType() != Void.TYPE) {
                return (U)method.invoke(receiver, args);
            }
            method.invoke(receiver, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw PRException.of(e);
        }
        return null;
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName) {
        return (T)AccessibleHelp.invoke(Objects.requireNonNull(AccessibleHelp.newObject(name, classLoader)), methodName);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, Class<?> ptype, Object arg) {
        return (T)AccessibleHelp.invoke(Objects.requireNonNull(AccessibleHelp.newObject(name, classLoader)), methodName, ptype, arg);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, Class<?>[] ptypes, Object[] args) {
        return (T)AccessibleHelp.invoke(Objects.requireNonNull(AccessibleHelp.newObject(name, classLoader)), methodName, ptypes, args);
    }

    public static <T, U> U invoke(T receiver, String methodName, String limit, Class<?> rtype) {
        MethodHandle methodHandle = AccessibleHelp.getMethodHandle(limit, MethodHandles.lookup(), receiver, methodName, MethodType.methodType(rtype == null ? Void.TYPE : rtype));
        try {
            if (rtype != null && rtype != Void.TYPE) {
                return (U)methodHandle.invokeWithArguments(new Object[0]);
            }
            methodHandle.invokeWithArguments(new Object[0]);
        }
        catch (Throwable t) {
            return AccessibleHelp.invoke(receiver, methodName);
        }
        return null;
    }

    private static <T> MethodHandle getMethodHandle(String limit, MethodHandles.Lookup lookup, T receiver, String name, MethodType type) {
        try {
            if ("static".equals(limit)) {
                return lookup.findStatic(receiver.getClass(), name, type);
            }
            try {
                return lookup.findVirtual(receiver.getClass(), name, type).bindTo(receiver);
            }
            catch (NoSuchMethodException e) {
                throw PRException.of(ServerFailure.NoSuchMethodException);
            }
            catch (IllegalAccessException e) {
                return lookup.findStatic(receiver.getClass(), name, type);
            }
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public static <T, U> U invoke(T receiver, String methodName, Class<?> rtype) {
        return AccessibleHelp.invoke(receiver, methodName, "", rtype);
    }

    public static <T, U> U invoke(T receiver, String methodName, String limit, Class<?> rtype, Class<?> ptype, Object arg) {
        MethodHandle methodHandle = AccessibleHelp.getMethodHandle(limit, MethodHandles.lookup(), receiver, methodName, MethodType.methodType(rtype == null ? Void.TYPE : rtype, ptype));
        try {
            if (rtype != null && rtype != Void.TYPE) {
                return (U)methodHandle.invokeWithArguments(arg);
            }
            methodHandle.invokeWithArguments(arg);
        }
        catch (Throwable t) {
            return AccessibleHelp.invoke(receiver, methodName, ptype, arg);
        }
        return null;
    }

    public static <T, U> U invoke(T receiver, String methodName, Class<?> rtype, Class<?> ptype, Object arg) {
        return AccessibleHelp.invoke(receiver, methodName, null, rtype, ptype, arg);
    }

    public static <T, U> U invoke(T receiver, String methodName, String limit, Class<?> rtype, Class<?>[] ptypes, Object[] args) {
        MethodHandle methodHandle = AccessibleHelp.getMethodHandle(limit, MethodHandles.lookup(), receiver, methodName, MethodType.methodType(rtype == null ? Void.TYPE : rtype, ptypes));
        try {
            if (rtype != null && rtype != Void.TYPE) {
                return (U)methodHandle.invokeWithArguments(args);
            }
            methodHandle.invokeWithArguments(args);
        }
        catch (Throwable t) {
            return AccessibleHelp.invoke(receiver, methodName, ptypes, args);
        }
        return null;
    }

    public static <T, U> U invoke(T receiver, String methodName, Class<?> rtype, Class<?>[] ptypes, Object[] args) {
        return AccessibleHelp.invoke(receiver, methodName, null, rtype, ptypes, args);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, String limit, Class<?> rtype) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, limit, rtype);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, Class<?> rtype) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, "", rtype);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, String limit, Class<?> rtype, Class<?> ptype, Object arg) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, limit, rtype, ptype, arg);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, Class<?> rtype, Class<?> ptype, Object arg) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, null, rtype, ptype, arg);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, String limit, Class<?> rtype, Class<?>[] ptypes, Object[] args) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, limit, rtype, ptypes, args);
    }

    public static <T> T invoke(String name, ClassLoader classLoader, String methodName, Class<?> rtype, Class<?>[] ptypes, Object[] args) {
        return (T)AccessibleHelp.invoke(AccessibleHelp.newObject(name, classLoader), methodName, null, rtype, ptypes, args);
    }

    public static boolean isAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c) {
        return a != null && c != null && a.isAnnotationPresent(c);
    }

    public static boolean nonAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c) {
        return !AccessibleHelp.isAnnotationPresent(a, c);
    }

    public static boolean isAnyAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c1, Class<? extends Annotation> c2) {
        return AccessibleHelp.isAnnotationPresent(a, c1) || AccessibleHelp.isAnnotationPresent(a, c2);
    }

    public static boolean nonAnyAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c1, Class<? extends Annotation> c2) {
        return !AccessibleHelp.isAnyAnnotationPresent(a, c1, c2);
    }

    public static boolean isAnyAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> ... cs) {
        return ((Stream)Arrays.stream(cs).parallel()).anyMatch(c -> AccessibleHelp.isAnnotationPresent(a, c));
    }

    public static boolean nonAnyAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> ... cs) {
        return !AccessibleHelp.isAnyAnnotationPresent(a, cs);
    }

    public static boolean isAllAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c1, Class<? extends Annotation> c2) {
        return AccessibleHelp.isAnnotationPresent(a, c1) && AccessibleHelp.isAnnotationPresent(a, c2);
    }

    public static boolean nonAllAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> c1, Class<? extends Annotation> c2) {
        return !AccessibleHelp.isAllAnnotationPresent(a, c1, c2);
    }

    public static boolean isAllAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> ... cs) {
        return ((Stream)Arrays.stream(cs).parallel()).allMatch(c -> AccessibleHelp.isAnnotationPresent(a, c));
    }

    public static boolean nonAllAnnotationPresent(AnnotatedElement a, Class<? extends Annotation> ... cs) {
        return !AccessibleHelp.isAllAnnotationPresent(a, cs);
    }

    public static <T> T getField(Object obj, Predicate<Field> predicate) {
        List<Field> fields;
        if (obj == null || (fields = AccessibleHelp.fields(obj.getClass(), predicate, 1)).isEmpty()) {
            return null;
        }
        return AccessibleHelp.getField(fields.get(0), obj);
    }

    public static <T, A extends Annotation> T getFieldByAnnotation(Object obj, Class<A> cls, Predicate<A> predicate) {
        return AccessibleHelp.getField(obj, (Field f) -> AccessibleHelp.isAnnotationPresent(f, cls) && (predicate == null || predicate.test(f.getAnnotation(cls))));
    }

    public static <T, A extends Annotation> T getFieldByAnnotation(Object obj, Class<A> cls) {
        return AccessibleHelp.getField(obj, (Field f) -> AccessibleHelp.isAnnotationPresent(f, cls));
    }

    public static void setField(Object obj, Predicate<Field> predicate, Object value) {
        List<Field> fields;
        if (obj == null || (fields = AccessibleHelp.fields(obj.getClass(), predicate, 1)).isEmpty()) {
            return;
        }
        AccessibleHelp.setField(fields.get(0), obj, value);
    }

    public static <A extends Annotation> void setFieldByAnnotation(Object obj, Class<A> cls, Predicate<A> predicate, Object value) {
        AccessibleHelp.setField(obj, (Field f) -> AccessibleHelp.isAnnotationPresent(f, cls) && (predicate == null || predicate.test(f.getAnnotation(cls))), value);
    }

    public static <A extends Annotation> void setFieldByAnnotation(Object obj, Class<A> cls, Object value) {
        AccessibleHelp.setField(obj, (Field f) -> AccessibleHelp.isAnnotationPresent(f, cls), value);
    }

    public static void setField(Object obj, Function<Field, Object> func) {
        if (Validator.isBlank(obj) || func == null) {
            return;
        }
        Class<?> cls = obj.getClass();
        List result = FIELD_CACHE.computeIfAbsent(cls, k -> {
            LinkedList fields = new LinkedList();
            Class cur = cls;
            do {
                Arrays.stream(cur.getDeclaredFields()).map(AccessibleHelp::accessible).forEach(fields::add);
            } while ((cur = cur.getSuperclass()) != null && cur != Object.class);
            return fields.isEmpty() ? Collections.emptyList() : new ArrayList(fields);
        });
        if (result.isEmpty()) {
            return;
        }
        result.forEach(f -> {
            Object value = func.apply((Field)f);
            if (value == NullConstant.OBJECT) {
                return;
            }
            AccessibleHelp.setField(f, obj, value);
        });
    }

    public static final class CustomClassLoader
    extends ClassLoader {
        private final Function<String, byte[]> classByteFunc;

        public CustomClassLoader(Function<String, byte[]> classByteFunc) {
            super(CustomClassLoader.class.getClassLoader());
            this.classByteFunc = classByteFunc;
        }

        public CustomClassLoader() {
            this((Function<String, byte[]>)null);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (Validator.nonBlank(name)) {
                return super.loadClass(name, true);
            }
            return this.classByteFunc == null ? null : this.loadClass(this.classByteFunc.apply(null));
        }

        public Class<?> loadClass(byte[] bytes) {
            Validator.requireNonEmpty(bytes);
            return this.defineClass(null, bytes, 0, bytes.length);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes;
            if (this.classByteFunc != null && Validator.nonEmpty(bytes = this.classByteFunc.apply(name))) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            return super.findClass(name);
        }
    }
}

