/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import shz.PRException;
import shz.constant.ArrayConstant;

public final class AsmHelp {
    private static final Map<Method, String[]> METHOD_PARAMETER_NAMES_CACHE = new ConcurrentHashMap<Method, String[]>(128);

    private AsmHelp() {
        throw new IllegalStateException();
    }

    public static String[] getParameterNames(final Method method) {
        return METHOD_PARAMETER_NAMES_CACHE.computeIfAbsent(method, k -> {
            Class<?>[] pTypes = method.getParameterTypes();
            if (pTypes.length == 0) {
                return ArrayConstant.EMPTY_STRING_ARRAY;
            }
            final Type[] types = (Type[])Arrays.stream(pTypes).map(Type::getType).toArray(Type[]::new);
            final String[] pNames = new String[pTypes.length];
            String cName = method.getDeclaringClass().getName();
            cName = cName.substring(cName.lastIndexOf(".") + 1) + ".class";
            InputStream is = method.getDeclaringClass().getResourceAsStream(cName);
            try {
                ClassReader classReader = new ClassReader(is);
                classReader.accept(new ClassVisitor(262144){

                    @Override
                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        Object[] aTypes = Type.getArgumentTypes(desc);
                        if (method.getName().equals(name) && Arrays.equals(aTypes, types)) {
                            return new MethodVisitor(262144){

                                @Override
                                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                                    if (index < pNames.length && Modifier.isStatic(method.getModifiers())) {
                                        pNames[index] = name;
                                    } else if (index <= pNames.length && index > 0) {
                                        pNames[index - 1] = name;
                                    }
                                }
                            };
                        }
                        return null;
                    }
                }, 0);
            }
            catch (IOException e) {
                throw PRException.of(e);
            }
            return pNames;
        });
    }
}

