/*
 * Decompiled with CFR 0.152.
 */
package shz;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import shz.FileHelp;
import shz.IOHelp;
import shz.PRException;
import shz.ToList;
import shz.ToSet;
import shz.Validator;

public final class CmdHelp {
    private static final Map<String, Long> PID = new ConcurrentHashMap<String, Long>();
    private static final BiConsumer<Process, Long> END = (t, u) -> {
        try {
            if (u == null || u <= 0L) {
                t.waitFor();
            } else {
                t.waitFor((long)u, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw PRException.of(e);
        }
    };
    private static final String OK = "ok";

    private CmdHelp() {
        throw new IllegalStateException();
    }

    public static void execute(String command, ExecuteParam param) {
        try {
            Process process = Runtime.getRuntime().exec("cmd /c " + command, param.envp, param.file == null ? null : param.file.getParentFile());
            if (param.consumer != null) {
                IOHelp.read(IOHelp.getBr(process.getInputStream()), param.consumer);
            }
            if (param.pid != null && param.file != null) {
                PID.put(param.file.getAbsolutePath(), (Long)param.pid.apply(process));
            }
            if (param.end != null) {
                param.end.accept(process);
            }
        }
        catch (Throwable t) {
            throw PRException.of(t);
        }
    }

    public static void execute(String command) {
        CmdHelp.execute(command, ExecuteParam.of());
    }

    public static Future<Boolean> isStarted(String name, long timeout) {
        return CompletableFuture.supplyAsync(() -> {
            if (Validator.isBlank(name)) {
                return false;
            }
            AtomicBoolean result = new AtomicBoolean();
            try {
                CmdHelp.execute("tasklist", ExecuteParam.of().consumer(t -> {
                    if (ToSet.asSet(t.split("\\s+")).contains(name)) {
                        result.set(true);
                    }
                }).end(t -> END.accept((Process)t, timeout)));
            }
            catch (Throwable e) {
                throw PRException.of(e);
            }
            return result.get();
        });
    }

    public static Future<Boolean> isStarted(String name) {
        return CmdHelp.isStarted(name, 1500L);
    }

    public static Future<String> start(ExecuteParam param) {
        if (param.file == null) {
            param.file = FileHelp.findFile(param.path, param.timeout);
        }
        return CompletableFuture.supplyAsync(() -> {
            String validFile = CmdHelp.validFile(param.file);
            if (validFile != null) {
                return validFile;
            }
            String name = param.file.getName();
            Future<Boolean> started = CmdHelp.isStarted(name);
            try {
                if (started.get().booleanValue()) {
                    return "[" + name + "] already running";
                }
            }
            catch (InterruptedException | ExecutionException e) {
                return e.getMessage();
            }
            String params = name;
            if (Validator.nonBlank(param.args)) {
                params = params + Arrays.stream(param.args).collect(Collectors.joining(" ", " ", ""));
            }
            try {
                if (param.silent) {
                    CmdHelp.execute(params, param);
                } else {
                    CmdHelp.execute("start " + params, param);
                }
            }
            catch (Throwable t) {
                return t.getMessage();
            }
            return OK;
        });
    }

    private static String validFile(File execute) {
        if (execute == null) {
            return "the program is not exist";
        }
        if (!execute.isFile()) {
            return "[" + execute.getName() + "] is not file";
        }
        if (!execute.canExecute()) {
            return "[" + execute.getName() + "] is can't execute";
        }
        return null;
    }

    public static List<Future<String>> start(ExecuteParam ... ps) {
        return ToList.explicitCollect(Arrays.stream(ps).map(CmdHelp::start), ps.length);
    }

    public static Future<String> close(ExecuteParam param) {
        if (param.file == null) {
            param.file = FileHelp.findFile(param.path, param.timeout);
        }
        return CompletableFuture.supplyAsync(() -> {
            String validFile = CmdHelp.validFile(param.file);
            if (validFile != null) {
                return validFile;
            }
            String name = param.file.getName();
            Future<Boolean> started = CmdHelp.isStarted(name);
            try {
                if (!started.get().booleanValue()) {
                    return "[" + name + "] not in running";
                }
            }
            catch (InterruptedException | ExecutionException e) {
                return e.getMessage();
            }
            String path = param.file.getAbsolutePath();
            boolean flag = PID.containsKey(path);
            String command = flag ? "taskkill /pid " + PID.get(path) + " /f /t " : "taskkill /f /im " + name;
            try {
                CmdHelp.execute(command, param);
            }
            catch (Throwable t) {
                return t.getMessage();
            }
            if (flag) {
                PID.remove(path);
            }
            return OK;
        });
    }

    public static Future<String> close(String path) {
        return CmdHelp.close(ExecuteParam.of().path(path).end(t -> {
            END.accept((Process)t, (Long)null);
            t.destroyForcibly();
        }));
    }

    public static List<Future<String>> close(ExecuteParam ... ps) {
        return ToList.explicitCollect(Arrays.stream(ps).map(CmdHelp::close), ps.length);
    }

    public static List<Future<String>> close(String ... ps) {
        return ToList.explicitCollect(Arrays.stream(ps).map(CmdHelp::close), ps.length);
    }

    public static Future<String> restart(ExecuteParam param) {
        if (param.file == null) {
            param.file = FileHelp.findFile(param.path, param.timeout);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                Consumer end = param.end;
                String result = CmdHelp.close(param.end(t -> {
                    END.accept((Process)t, (Long)null);
                    t.destroyForcibly();
                    if (t.isAlive()) {
                        throw new RuntimeException("the program is alive");
                    }
                })).get();
                if (OK.equals(result)) {
                    return CmdHelp.restart(param.end(end)).get();
                }
                return result;
            }
            catch (InterruptedException | ExecutionException e) {
                return e.getMessage();
            }
        });
    }

    public static List<Future<String>> restart(ExecuteParam ... ps) {
        return ToList.explicitCollect(Arrays.stream(ps).map(CmdHelp::restart), ps.length);
    }

    public static void displaydns() {
        CmdHelp.execute("ipconfig /displaydns");
    }

    public static void flushdns() {
        CmdHelp.execute("ipconfig /flushdns");
    }

    public static void renew() {
        CmdHelp.execute("ipconfig /renew");
    }

    public static void mvnInstall(String groupId, String artifactId, String version, String packaging, String file) {
        CmdHelp.execute("mvn install:install-file -DgroupId=" + groupId + " -DartifactId=" + artifactId + " -Dversion=" + version + " -Dpackaging=" + packaging + " -Dfile=" + file);
    }

    public static void shutdown(int seconds) {
        CmdHelp.execute("shutdown -s -t " + seconds);
    }

    public static void cancelShutdown() {
        CmdHelp.execute("shutdown -a");
    }

    public static final class ExecuteParam {
        private String[] envp;
        private File file;
        private Consumer<String> consumer;
        private Function<Process, Long> pid;
        private Consumer<Process> end;
        private String path;
        private long timeout;
        private boolean silent = true;
        private String[] args;

        private ExecuteParam() {
        }

        public static ExecuteParam of() {
            return new ExecuteParam();
        }

        public ExecuteParam envp(String[] envp) {
            this.envp = envp;
            return this;
        }

        public ExecuteParam file(File file) {
            this.file = file;
            return this;
        }

        public ExecuteParam consumer(Consumer<String> consumer) {
            this.consumer = consumer;
            return this;
        }

        public ExecuteParam pid(Function<Process, Long> pid) {
            this.pid = pid;
            return this;
        }

        public ExecuteParam end(Consumer<Process> end) {
            this.end = end;
            return this;
        }

        public ExecuteParam path(String path) {
            this.path = path;
            return this;
        }

        public ExecuteParam timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public ExecuteParam silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public ExecuteParam args(String ... args) {
            this.args = args;
            return this;
        }
    }
}

